<?php

/**
 * @package     dxfa
 * @subpackage  com_dxfontawesome
 *
 * @copyright   Copyright (C) 2005 - 2021 Jtotal. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\Registry\Registry;

defined('_JEXEC') or die;

$jinput = Factory::getApplication()->input;
$editor = $jinput->get('editor', 'jform_articletext');

$app = Factory::getApplication();
$doc = $app->getDocument();
$isFront = ($app->isClient('site') ? 'administrator/' : '');

$plugin = PluginHelper::getPlugin('content', 'jtfaparser');
$pluginParams = new Registry($plugin->params);

$fa_pro = $pluginParams->get('use_pro', 0);
$fa_kit = $pluginParams->get('pro_kit', '');

?>
<script>
var jtfabase = '<?php echo Uri::root(); ?>';
</script>

<?php

if ($fa_pro == 1) {
    ///$fa_address = 'https://kit.fontawesome.com/'.$fa_kit.'.css';
    echo '<script src="' . $fa_kit . '" crossorigin="anonymous" ></script>';
} else {
    $fa_address = Uri::root(true) . '/media/templates/administrator/atum/css/vendor/fontawesome-free/fontawesome.css?5.15.4';

    echo '<link href="' . $fa_address . '" rel="stylesheet">';
}

?>

<link href="<?php echo Uri::root(true) . '/media/plg_content_jtfaparser/css/jtfaeditor.css'; ?>" rel="stylesheet">

<script src="<?php echo Uri::root() . '/media/plg_content_jtfaparser/js/jtfaeditor.js?version=6.4.0' ?>"></script>


<div class="dxfa_flex">
    <form class="dx_fa_form">
        

<input type="hidden" id="editor_name" name="editor_name" value="<?php echo $editor; ?>">
        <p></p>
        <div id="dx_fa_wrapper" class="container">


            <div id="dx_search" class="">
                <div class="btn-wrapper input-group mb-3">
                    <input type="text" name="dx_filter_search" id="dx_filter_search" class="form-control" value=""
                        placeholder="Search in fontawesome.com" data-original-title="" title="">
                    <button type="button" class="btn dx_filter_button_v6 btn btn-outline-secondary" title=""
                        data-original-title="dx_filter_search" onclick="searchOnFontAwesome();">
                        <span class="icon-search"></span> <i class="fab fa-font-awesome-flag"></i>
                    </button>

                </div>
            </div>

            <hr class="clearfix">

            <div id="dx_insert" class="input-group mb-3">
                <div class="btn-wrapper input-group mb-3">
                    <input type="text" name="dx_filter_apply" id="dx_filter_apply" class="form-control" value=""
                        placeholder="joomla" data-original-title="" title="">
                    <button type="button" class="btn dx_filter_button_v6 btn-outline-secondary" title=""
                        data-original-title="dx_filter_search" onclick="insertFromInput()">
                        <i class="fas fa-check"></i>
                    </button>

                </div>

            </div>

            <small> Valid: <?php echo htmlentities('<i class="fab fa-joomla"></i>') ?>, fa-joomla, joomla</small>

            <!--CONTENEDOR -->
            <div class="contenedor">
                <div id="icons">
                    <hr>
                    <div class="well">
                        <table class="table">
                            <thead>
                                <tr>
                                    <td><small>Solid</small></td>
                                    <td><small>Regular</small></td>
                                    <td><small>Light</small></td>
                                    <td><small>Duotone</small></td>
                                    <td><small>Brand</small></td>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><a id="icon_prew_s" onclick="insertSelectedIcon(this.innerHTML)"></a></td>
                                    <td><a id="icon_prew_r" onclick="insertSelectedIcon(this.innerHTML)"></a></td>
                                    <td><a id="icon_prew_l" onclick="insertSelectedIcon(this.innerHTML)"></a></td>
                                    <td><a id="icon_prew_d" onclick="insertSelectedIcon(this.innerHTML)"></a></td>
                                    <td><a id="icon_prew_b" onclick="insertSelectedIcon(this.innerHTML)"></a></td>
                                </tr>
                            </tbody>

                        </table>
                        <hr>
                    </div>
                </div>
            </div>
        </div>


        <div class="container">
            <div class="fa_copyright"><strong>FontAwesome</strong> by <a href="https://fontawesome.com"
                    target="_blank">Dave Gandy</a></div>
            <div class="fa_copyright"><strong>JTfa</strong> button package by <a
                    href="https://jtotal.org/joomla/plugins/dxfa" target="_blank">JTotal</a></div>
            <div class="fa_copyright"><strong>Do you want to use PRO kit? Configure it in the </strong> <a class="link"
                    href="index.php?option=com_plugins&filter[search]=FA%20parser" target="_blank">FAparser plugin</a>
            </div>
        </div>

    </form>

    <div id="dx_fa_insert_wrapper">
        <div class="dx_fa_tools">


            <fieldset id="dx_fa_color_fs" class="input colorpicker">
                <input type="checkbox" id="dx_fa_color_checker" name="dx_fa_color_checker" value="" selected="selected">
                <label>color</label>
                <input type="color" id="dx_fa_color" class="input-colorpicker" name="dx_fa_color" value="#444444">

            </fieldset>
            <hr>

        </div>

        <div id="dx_fa_preview">
            <i id="dx_fa_preview_i" class="fas fa-asterisk"></i>
        </div>

        <br>

        <div class="btn_dx_fa_button_wrapper">
            <a class="btn_dx_fa_button btn btn-success bg-success text-light" onclick="insertFontAwesome('<?php echo $editor; ?>')"> <i class="far fa-plus-square"></i>
                <?php echo Text::_('INSERT'); ?> </a>
        </div>
    </div>
</div>
