<?php

/**
 * @package     dxfa
 * @subpackage  plg_editor.dxfontawesome
 *
 * @copyright   Copyright (C) 2005 - 2023 Jtotal. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
*/

defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Jtotal\Plugin\EditorsXtd\Jtfabutton\Extension\Jtfabutton;

return new class () implements ServiceProviderInterface {
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   4.3.0
     */
    public function register(Container $container)
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $dispatcher = $container->get(DispatcherInterface::class);

                $plugin     = new Jtfabutton(
                    $dispatcher,
                    (array) PluginHelper::getPlugin('editors-xtd', 'jtfabutton')
                );
                $plugin->setApplication(Factory::getApplication());

                return $plugin;
            }
        );
    }
};
