<?php

/**
 * @package     dxfa
 * @subpackage  plg_editor.dxfontawesome
 *
 * @copyright   Copyright (C) 2005 - 2021 Jtotal. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Jtotal\Plugin\EditorsXtd\Jtfabutton\Extension;

use Joomla\CMS\Event\Editor\EditorButtonsSetupEvent;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Session\Session;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Editor\Button\Button;

// no direct access
defined('_JEXEC') or die;

final class Jtfabutton extends CMSPlugin implements SubscriberInterface
{
    /**
     * Load the language file on instantiation.
     *
     * @var    boolean
     * @since  3.1
     */
    protected $autoloadLanguage = true;

    /**
     * Returns an array of events this subscriber will listen to.
     *
     * @return  array
     */
    public static function getSubscribedEvents(): array
    {
        return ['onEditorButtonsSetup' => 'onEditorButtonsSetup'];
    }

    /**
     * @param  EditorButtonsSetupEvent $event
     * @return void
     *
     * @since   5.1.0
     */
    public function onEditorButtonsSetup(EditorButtonsSetupEvent $event): void
    {
        $disabled = $event->getDisabledButtons();

        if (\in_array($this->_name, $disabled)) {
            return;
        }

        $button = $this->onDisplay($event->getEditorId(), $event->getAsset(), $event->getAuthor());

        if ($button) {
            $event->getButtonsRegistry()->add($button);
        }
    }

    /**
     * Display the button.
     *
     * @param   string   $name    The name of the button to display.
     * @param   string   $asset   The name of the asset being edited.
     * @param   integer  $author  The id of the author owning the asset being edited.
     *
     * @return  Button|false
     *
     * @since   1.5
     */
    public function onDisplay($name, $asset, $author)
    {
/*
        $openHandlerUrl = '/index.php?option=com_ajax&plugin=Jtfaparser&group=content&format=raw&action=openhandler';
        $openHandlerUrl .= '&' . Session::getFormToken() . '=1';
        $openHandlerUrl .= '&editor=' . $name;

        $button = new \stdClass();
        $button->modal = true;
        $button->class = 'btn';
        $button->link = $openHandlerUrl;
        $button->text = Text::_('FA Icons');
        $button->icon = ' fa-brands fa-font-awesome';
        $button->iconSVG = '<svg class="svg-inline--fa fa-font-awesome" aria-hidden="true" focusable="false" data-prefix="fab" data-icon="font-awesome" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" data-fa-i2svg=""><path fill="currentColor" d="M448 48V384C385 407 366 416 329 416C266 416 242 384 179 384C159 384 143 388 128 392V328C143 324 159 320 179 320C242 320 266 352 329 352C349 352 364 349 384 343V135C364 141 349 144 329 144C266 144 242 112 179 112C128 112 104 133 64 141V448C64 466 50 480 32 480S0 466 0 448V64C0 46 14 32 32 32S64 46 64 64V77C104 69 128 48 179 48C242 48 266 80 329 80C366 80 385 71 448 48Z"></path></svg>';
        $button->name = $this->_type . '_' . $this->_name;
        $button->options = ['iframe' => true, 'width' => 800, 'height' => 520];
*/
        $link = 'index.php?option=com_ajax&plugin=Jtfaparser&group=content&format=raw&action=openhandler&' . Session::getFormToken() . '=1&editor=' . $name;

        return new Button(
            $this->_name,
            [
                'action'  => 'modal',
                'text'    => Text::_('FA Icons'),
                'name'    => $this->_type . '_' . $this->_name,
                'icon'    => 'fa-brands fa-font-awesome',
                'link'    => $link,
                'iconSVG' => '<svg class="svg-inline--fa fa-font-awesome" aria-hidden="true" focusable="false" data-prefix="fab" data-icon="font-awesome" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" data-fa-i2svg=""><path fill="currentColor" d="M448 48V384C385 407 366 416 329 416C266 416 242 384 179 384C159 384 143 388 128 392V328C143 324 159 320 179 320C242 320 266 352 329 352C349 352 364 349 384 343V135C364 141 349 144 329 144C266 144 242 112 179 112C128 112 104 133 64 141V448C64 466 50 480 32 480S0 466 0 448V64C0 46 14 32 32 32S64 46 64 64V77C104 69 128 48 179 48C242 48 266 80 329 80C366 80 385 71 448 48Z"></path></svg>',
            ],
            [
                'popupType'  => 'iframe',
                //'textHeader' => Text::_('PLG_IMAGE_BUTTON_IMAGE'),
                'iconHeader' => 'icon-pictures',
            ]
        );

        return $button;
    }
}
