<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2021 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace JTFramework;

use Joomla\CMS\Factory;
use JTFramework\JTdebug;

defined('_JEXEC') or die('Restricted access');

/**
 *  Fa Class
 */
class Fa
{

    /**
     * load Fa scripts
     *
     * @return void
     */
    public static function getFa5CDN()
    {

        //add custom FA5 free icons
        $doc = Factory::getDocument();
        $doc->addScript('https://use.fontawesome.com/releases/v5.15.3/js/all.js', array(), array('async' => 'async', 'crossorigin' => 'anonymous'));
        //$doc->addScript('https://kit.fontawesome.com/58c27e83fb.js',array(), array('async' => 'async','crossorigin'=>'anonymous'));

        JTdebug::addDebug('FA5', 'code', 'Fa5 loaded', microtime(true), 'table-info', basename(__FILE__, '.php'));
        return true;

    }

    /**
     * load Fa scripts
     *
     * @return void
     */
    public static function getFa6CDN()
    {

        //add custom FA6 free icons
        $doc = Factory::getDocument();
        $wa = $doc->getWebAssetManager();
        $wa->registerAndUseScript('fa6CDN', 'https://use.fontawesome.com/releases/v6.4.2/js/all.js', array('async' => 'async', 'crossorigin' => 'anonymous'));
        JTdebug::addDebug('FA6', 'code', 'Fa6 6.4.2 CDN loaded', microtime(true), 'table-info', basename(__FILE__, '.php'));
        return true;
    }

}
