<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2020 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

namespace JTFramework;
use JTFramework\JTdebug;
use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Language\Text;

defined( '_JEXEC' ) or die( 'Restricted access' );

/**
 *  JTmobiledetect Class
 */
class JTmobiledetect
{

    /**
     * Loads mobile_detect library
     *
     * @return bool
     */
	public static function getMobileDetect()
	{

        if(!class_exists('Mobile_Detect')){

            if(File::exists(JPATH_LIBRARIES.'/jtlibs/mobiledetectlib/Mobile_Detect.php')){
                include_once JPATH_LIBRARIES.'/jtlibs/mobiledetectlib/Mobile_Detect.php';
                JTdebug::addDebug('Mobile Detect', 'check-circle', 'Loaded', microtime(TRUE), 'table-success', basename(__FILE__, '.php'));

            }else{
                $app = Factory::getApplication();
                $app->enqueueMessage(Text::_('JT_LIBS_NOT_FOUND'), 'error');
                return false;
            }

        }

        return true;

	}
    
}
