<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2020 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use JTFramework\JTfunc;

defined('JPATH_BASE') or die;

if (is_file(JPATH_PLUGINS . '/system/jtframework/autoload.php')) {
	require_once JPATH_PLUGINS . '/system/jtframework/autoload.php';
} else {
	$app = Factory::getApplication();
	$app->enqueueMessage(Text::_('JT_FW_NOT_FOUND'), 'error');
	return;
}

/**
 * Layout variables
 * -----------------
 * @var array   $displayData
 * @var string  $field
 * @var string  $autocomplete   Autocomplete attribute for the field.
 * @var boolean $autofocus      Is autofocus enabled?
 * @var string  $class          Classes for the input.
 * @var string  $description    Description of the field.
 * @var boolean $disabled       Is this field disabled?
 * @var string  $group          Group the field belongs to. <fields> section in form XML.
 * @var boolean $hidden         Is this field hidden in the form?
 * @var string  $hint           Placeholder for the field.
 * @var string  $id             DOM id of the field.
 * @var string  $label          Label of the field.
 * @var string  $labelclass     Classes to apply to the label.
 * @var boolean $multiple       Does this field support multiple values?
 * @var string  $name           Name of the input field.
 * @var string  $onchange       Onchange attribute for the field.
 * @var string  $onclick        Onclick attribute for the field.
 * @var string  $pattern        Pattern (Reg Ex) of value of the form field.
 * @var boolean $readonly       Is this field read only?
 * @var boolean $repeat         Allows extensions to duplicate elements.
 * @var boolean $required       Is this field required?
 * @var integer $size           Size attribute of the input.
 * @var boolean $spellcheck     Spellcheck state for the form field.
 * @var string  $validate       Validation rules to apply.
 * @var string  $value          Value attribute of the field.
 * @var array   $checkedOptions Options that will be set as checked.
 * @var boolean $hasValue       Has this field a value assigned?
 * @var array   $options        Options available for this field.
 * @var array   $inputType      Options available for this field.
 * @var string  $accept         File types that are accepted.
 * @var string  $prepend
 * @var string  $append
 * @var string  $width
 * @var string  $quantity
 * @var string  $input_type
 * @var string  $clone
 * @var string  $title
 */

extract($displayData);

// Including fallback code for HTML5 non supported browsers.
HTMLHelper::_('jquery.framework');
//HTMLHelper::_('script', 'system/html5fallback.js', ['version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9']);

//QUANTITY
//Number of inputs
$quantity = isset($quantity) ? $quantity : 1;
if (isset($quantity)) {
	$quantity = ($quantity == '') ? 1 : $quantity;
}

//INPUT TYPE
//text of number (or what)
$input_type = isset($input_type) ? $input_type : 'number';
if (isset($input_type)) {
	$input_type = ($input_type == '') ? 'number' : $input_type;
}

//CLONE
//clone button preppend and fa
$clone = ($clone == true) ? 'fas fa-link' : $clone;

//TITLE
//titles for popup
$title = isset($title) ? $title : false;
if ($title) {
	$title = explode(',', $title);
}

// Initialize some field attributes.
$attributes_range = [
	$class ? 'class="' . $class . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	!empty($onchange) ? 'onchange="' . $onchange . '"' : '',
	!empty($max) ? 'max="' . $max . '"' : '',
	!empty($step) ? 'step="' . $step . '"' : '',
	!empty($min) ? 'min="' . $min . '"' : '',
	$autofocus ? 'autofocus' : '',
];

$chars = strlen($max) ?: $size ?: 3;
if ($input_type == 'number') {
	$chars += 2;
}

$width = $chars * 8;

$attributes_number = [
	'class="input-mini text-right"',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	!empty($onchange) ? 'onchange="' . $onchange . '"' : '',
	isset($max) ? 'max="' . $max . '"' : '',
	!empty($step) ? 'step="' . $step . '"' : '',
	isset($min) ? 'min="' . $min . '"' : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? 'autofocus' : '',
	$width ? 'style="width:' . $width . 'px"' : '',
];

$classes = [];
if ($prepend) {
	$classes[] = 'input-prepend';
}
if ($append) {
	$classes[] = 'input-append';
}

if (strpos($prepend, 'icon-') === 0) {
	$prepend = '<span class="' . $prepend . '"></span>';
}

if (strpos($append, 'icon-') === 0) {
	$append = '<span class="' . $append . '"></span>';
}

if ($prepend && preg_match('#^[A-Z][A-Z0-9_]+$#', $prepend)) {
	$prepend = Text::_($prepend);
}

if ($append && preg_match('#^[A-Z][A-Z0-9_]+$#', $append)) {
	$append = Text::_($append);
}

if ($min == '') {
	$min = 0;
}

if ($max == '') {
	$max = 100;
}

if ($step == '') {
	$step = 1;
}

$input = '';

$input .= '<div class="input-group input-group-sm tm_wrapper_range input-append input-prepend flex-nowrap" id="tm_wrapper_' . $id . '">';

if ($prepend) {
	$input .= '<span class="add-on tmgrouped_prepend input-group-text bg-light text-dark">' . $prepend . '</span>';
}

if ($clone) {
	$input .= '<a class="btn btn-outline-info" onclick="tm_copy_button(this);"><i class="' . $clone . '"></i></a>';
}

$value_array = explode(',', $value);

for ($i = 0; $i <= ($quantity - 1); $i++) {

	$current_id = 'tm_input_' . $id . '_' . $i;

	//VALUE
	$current_value = (int) (isset($value_array[$i]) ? $value_array[$i] : 0);

	//TITLE
	$data_title = '';
	if ($title) {
		if (isset($title[($i)])) {
			$data_title = 'data-title="' . $title[($i)] . '"';
		}
	}

	$input .= '<input type="' . $input_type . '" class="input-mini form-control tm_input_top" ' . $data_title . ' name="' . $current_id . '" id="' . $current_id . '"
		value="' . $current_value . '"
		onfocus="tm_focus(this.id,this.value,' . $min . ',' . $max . ',' . $step . ');"
		onblur="tm_blur(this.id,this.value); "
		oninput="document.querySelector(\'input[name=\\\'tm_range_' . $current_id . '\\\']\').value=this.value;"
		onchange="tm_change(this.id);"
		' . implode(' ', $attributes_number) . ' />';
}

if ($append) {
	$input .= '<span class="add-on input-group-text bg-light text-dark"> ' . $append . '</span>';
}

$input .= '</div>';

//$input .= '<div class="input-group">';
/*
$input .=  '<input type="text" class="input-mini form-control tm_input_top" name="tm_input_right" id="tm_input_right_' . $id . '"
value=""
oninput="console.log(\'this\')"
onfocus="lala(this.id);"'
. ' />';

$input .=  '<input type="text" class="input-mini form-control tm_input_bottom" name="tm_input_bottom" id="tm_input_bottom_' . $id . '"
value=""
onfocus="lala(this.id);"'
. ' />';

$input .=  '<input type="text" class="input-mini form-control tm_input_top" name="tm_input_bottom" id="tm_input_bottom_' . $id . '" value=""
oninput="document.querySelector(\'input[data-for=\\\'' . $name . '\\\']\').value=this.value;"'
. ' />';

//$input .= '</div>';

 */

/* $input = '<input type="text" name="' . $name . '" id="' . $id . '" value="' . $value . '"
oninput="document.querySelector(\'input[data-for=\\\'' . $name . '\\\']\').value=this.value;"'
. ' ' . implode(' ', $attributes_number) . ' />'; */

$session = Factory::getSession();
$carga_script = false;
$script_session = $session->get('tm_script');
if (isset($script_session)) {
	$carga_script = true;
}

if (!JTfunc::functionLoaded('carga_tm_range_script')) : ?>
	<?Php

	$document = Factory::getDocument();

	$wa = $document->getWebAssetManager();
	$wa->registerAndUseScript(
		'webui-popover.js',
		'//cdnjs.cloudflare.com/ajax/libs/webui-popover/1.2.18/jquery.webui-popover.min.js',
		[],
		['integrity' => 'sha512-c7jfqR4Yc1iFS3KA+EceHmO91hjSfqNZ6cu00AKBE62BmQq7EOoCVGGwjV/OoaEG1teTU9nY6gBuToAzFfxMSw==', 'crossorigin' => 'anonymous', 'referrerpolicy' => 'no-referrer', 'defer' => 'defer']
	);

	$wa->registerAndUseStyle(
		'webui-popover.css',
		'//cdnjs.cloudflare.com/ajax/libs/webui-popover/1.2.18/jquery.webui-popover.min.css',
		[],
		array(
			'integrity' => 'sha512-n48mMpd2Ez+soTQuZManEgeJeSeBNynyPL7S23uY5zKXZiEpKn529rl4Zu01ZiJEyJPBYMPp5AxNQD3XRh1oeg==',
			'crossorigin' => 'anonymous', 'referrerpolicy' => 'no-referrer',
		)
	);

	$js = <<< JS
;;


		//FOCUS
        function tm_focus(id, value='', min='', max='', step=''){

			//console.log("focus: "+id)
            var selector = "#"+id;

			var uipopover = jQuery(selector).attr('data-target');
			if(uipopover == undefined){
				var range = '<input type="range" ';
					range += 'name="tm_range_'+id+'"' ;
					range += 'value="'+value+'"' ;
					range += 'oninput="document.querySelector(\'input[name='+id+']\').value=this.value;"';
					range += 'onblur="tm_range_blur(\''+id+'\','+value+');" ';
					range += 'min="'+min+'" ';
					range += 'max="'+max+'" ';
					range += 'step="'+step+'" ';
				range += '/>';

				range += '<a class="btn" onclick="tm_copy_input(\''+id+'\')"><i class="fas fa-link"></i></a>';
				jQuery(selector).webuiPopover({
					html:true,
					animation:'pop',
					placement:'top',
					arrow:true,
					type:'html',
					closeable:false,
					autoHide:false,
					dismissible:false,
					multi:true,
					trigger:'manual',
					content:range
				});
			}


			jQuery(selector).webuiPopover('show');

        }

        //INPUT EXIT

		function tm_blur(id,value=''){
			var selector = "#"+id;
			setTimeout(function()
			{
				var target = document.activeElement;
				if('tm_range_'+id == target.getAttribute('name')){
					//console.log('QUIETO TODO EL MUNDO!');
				}else{
					//console.log(selector);
					jQuery(selector).webuiPopover('hide');
				}
			}, 1);

		}

				//INPUT EXIT
		function tm_range_blur(id,value=''){
			var selector = "#"+id;
			setTimeout(function()
			{
				var target = document.activeElement;
				if(id == target.getAttribute('name')){
					//console.log('QUIETO TODO EL MUNDO!');
				}else{
					//console.log(selector);
					jQuery(selector).webuiPopover('hide');
				}
			}, 1);
			tm_change(id);
		}


		function tm_copy_input(id,value=''){
			var value = jQuery('#'+id).val();
			//console.log(jQuery('#'+id).val());
			jQuery('#'+id).parent().parent().find('input').val(value);
			tm_change(id);
			//console.log(id);
		}

		function tm_copy_button(element){
			var first_value = element.parentNode.getElementsByTagName("input")[0].value;
			jQuery('#'+element.parentNode.getAttribute('id')).children('input').val(first_value);

			//console.log();
			tm_change(element.parentNode.getElementsByTagName("input")[0].getAttribute('id'));
		}


		function tm_change(element){

			var final_input = jQuery("#"+element).parent().siblings('input');
			var selector = jQuery("#"+element).parent().children();
			var data = getFormData(selector);
			final_input.val(data);
			//console.log(data);
		}


		function getFormData(form){
			var unindexed_array = form.serializeArray();
			var indexed_array = [];
			var indexed_object = {};

			jQuery.map(unindexed_array, function(n, i){
				indexed_array.push(n['value']);
				//indexed_object[n['name']] = n['value'];
			});

			return indexed_array;
		}
JS;
	$document->addScriptDeclaration($js);

	/*
name='tm_input_jform_params__tm_desktop_custom__tm_desktop_custom0__tmcustom__tm_padding_0']').value=this.value;" onblur="tm_range_blur('tm_input_jform_params__tm_desktop_custom__tm_desktop_custom0__tmcustom__tm_padding_0',0);" min="0" max="50" step="1">

name=\'tm_input_jform_params__tm_mobile_custom__tm_mobile_custom0__tmcustom__tm_padding_1\']').value=this.value;" onblur="tm_range_blur('tm_input_jform_params__tm_mobile_custom__tm_mobile_custom0__tmcustom__tm_padding_1',0);" min="0" max="50" step="1">
 */

	?>





<?php endif; ?>



<div class="tm_grouped_input_wrapper">

	<?php echo $input; ?>

	<?php
	$input_json = '<input type="hidden" class="form-control" name="' . $name . '" value="' . htmlspecialchars($value) . '" id="' . $id . '" />';
	//$input_json =  '<textarea type="text" class="form-control" name="' . $name . '" value="' . $value . '" id="' . $id . '"></textarea>';
	echo $input_json;
	?>

</div>