<?php
/**
 * @package     Joomla.Site
 * @subpackage  Layout
 *
 * @copyright   (C) 2016 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

extract($displayData);


/**
 * Layout variables
 * -----------------
 * @var   string   $autocomplete    Autocomplete attribute for the field.
 * @var   boolean  $autofocus       Is autofocus enabled?
 * @var   string   $class           Classes for the input.
 * @var   string   $description     Description of the field.
 * @var   boolean  $disabled        Is this field disabled?
 * @var   string   $group           Group the field belongs to. <fields> section in form XML.
 * @var   boolean  $hidden          Is this field hidden in the form?
 * @var   string   $hint            Placeholder for the field.
 * @var   string   $id              DOM id of the field.
 * @var   string   $label           Label of the field.
 * @var   string   $labelclass      Classes to apply to the label.
 * @var   boolean  $multiple        Does this field support multiple values?
 * @var   string   $name            Name of the input field.
 * @var   string   $onchange        Onchange attribute for the field.
 * @var   string   $onclick         Onclick attribute for the field.
 * @var   string   $pattern         Pattern (Reg Ex) of value of the form field.
 * @var   boolean  $readonly        Is this field read only?
 * @var   boolean  $repeat          Allows extensions to duplicate elements.
 * @var   boolean  $required        Is this field required?
 * @var   integer  $size            Size attribute of the input.
 * @var   boolean  $spellcheck      Spellcheck state for the form field.
 * @var   string   $validate        Validation rules to apply.
 * @var   string   $value           Value attribute of the field.
 * @var   array    $checkedOptions  Options that will be set as checked.
 * @var   boolean  $hasValue        Has this field a value assigned?
 * @var   array    $options         Options available for this field.
 * @var   array    $inputType       Options available for this field.
 * @var   string   $accept          File types that are accepted.
 * @var   string   $dataAttribute   Miscellaneous data attributes preprocessed for HTML output
 * @var   array    $dataAttributes  Miscellaneous data attribute for eg, data-*.
 */

// Initialize some field attributes.
//default joomla attribute
$attributes = array(
	$class ? 'class="form-range ' . $class . '"' : 'class="form-range"',
	!empty($description) ? 'aria-describedby="' . ($id ?: $name) . '-desc"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	!empty($onchange) ? 'onchange="' . $onchange . '"' : '',
	!empty($max) ? 'max="' . $max . '"' : '',
	!empty($step) ? 'step="' . $step . '"' : '',
	!empty($min) ? 'min="' . $min . '"' : '',
	$autofocus ? 'autofocus' : '',
	$dataAttribute,
);
?>
<!-- <input
	type="range"
	name="<?php echo $name; ?>"
	id="<?php echo $id; ?>"
	value="<?php echo htmlspecialchars($value, ENT_COMPAT, 'UTF-8'); ?>"
	<?php echo implode(' ', $attributes); ?>>
 -->
<?Php



/********************************
 * JTOTAL
 */




//JTOTAL
if (!empty($prepend) && empty($addonBefore)) $addonBefore = $prepend;
if (!empty($append) && empty($addonAfter)) $addonAfter = $append;





// Initialize some field attributes.
$attributes_range = [
	$class ? 'class="form-range ' . $class . '"' : 'class="form-range"',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	! empty($onchange) ? 'onchange="' . $onchange . '"' : '',
	! empty($max) ? 'max="' . $max . '"' : '',
	! empty($step) ? 'step="' . $step . '"' : '',
	! empty($min) ? 'min="' . $min . '"' : '',
	$autofocus ? 'autofocus' : '',
];

$chars = strlen($max) ?: $size ?: 3;
$width = $chars * 8;

$attributes_number = [
	'class="input-mini text-right"',
	! empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	! empty($onchange) ? 'onchange="' . $onchange . '"' : '',
	isset($max) ? 'max="' . $max . '"' : '',
	! empty($step) ? 'step="' . $step . '"' : '',
	isset($min) ? 'min="' . $min . '"' : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? 'autofocus' : '',
	$width ? 'style="width:'.$width.'px"' : '',
];



$classes = [];
if ($prepend)
{
	$classes[] = 'input-prepend input-group ';
}
if ($append)
{
	$classes[] = 'input-append input-group ';
}

if (strpos($prepend, 'icon-') === 0)
{
	$prepend = '<span class="' . $prepend . '"></span>';
}

if (strpos($append, 'icon-') === 0)
{
	$append = '<span class="' . $append . '"></span>';
}

if ($prepend && preg_match('#^[A-Z][A-Z0-9_]+$#', $prepend))
{
	$prepend = Text::_($prepend);
}

if ($append && preg_match('#^[A-Z][A-Z0-9_]+$#', $append))
{
	$append = Text::_($append);
}


$input = '<input class="form-control btn-light" aria-label="'.$name.'" type="text" name="' . $name . '" id="' . $id . '_input" value="' . $value . '"
       oninput="document.querySelector(\'input[data-for=\\\'' . $name . '\\\']\').value=this.value;"'
	. ' ' . implode(' ', $attributes_number) . ' />';



?>


<div class="tmrange_wrapper input-group">

  
	<?php if ($prepend): ?>
		<span class="input-group-text bg-light text-dark"><?php echo $prepend; ?></span>
	<?php endif; ?>

	<?php echo $input; ?>

	<?php if ($append): ?>
		<span class="input-group-text bg-light text-dark"><?php echo $append; ?></span>
	<?php endif; ?>

</div>

<input type="range" id="<?php echo $id; ?>" data-for="<?php echo $name; ?>" value="<?php echo $value; ?>"
		oninput="this.parentNode.querySelector('input').value=this.value;"
		<?php echo implode(' ', $attributes_range); ?> />


