var cal;

function initCalendar(){

    var current_lang = 'es';

    var lang = {
        'eng':{
            daynames: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat']
        },
        'es':{
            daynames: ['Dom', 'Lun', 'Mar', 'Mié', 'Jue', 'Vie', 'Sáb']
        }
    }
 

    var MONTHLY_CUSTOM_THEME = {
        // month header 'dayname'
        'month.dayname.height': '42px',
        'month.dayname.borderLeft': 'none',
        'month.dayname.paddingLeft': '8px',
        'month.dayname.paddingRight': '0',
        'month.dayname.fontSize': '13px',
        'month.dayname.backgroundColor': 'inherit',
        'month.dayname.fontWeight': 'normal',
        'month.dayname.textAlign': 'left',
    
        // month day grid cell 'day'
        'month.holidayExceptThisMonth.color': '#f3acac',
        'month.dayExceptThisMonth.color': '#bbb',
        'month.weekend.backgroundColor': '#fafafa',
        'month.day.fontSize': '16px',
    
        // month schedule style
        'month.schedule.borderRadius': '5px',
        'month.schedule.height': '18px',
        'month.schedule.marginTop': '2px',
        'month.schedule.marginLeft': '10px',
        'month.schedule.marginRight': '10px',
    
        // month more view
        'month.moreView.boxShadow': 'none',
        'month.moreView.paddingBottom': '0',
        'month.moreView.border': '1px solid #9a935a',
        'month.moreView.backgroundColor': '#f9f3c6',
        'month.moreViewTitle.height': '28px',
        'month.moreViewTitle.marginBottom': '0',
        'month.moreViewTitle.backgroundColor': '#f4f4f4',
        'month.moreViewTitle.borderBottom': '1px solid #ddd',
        'month.moreViewTitle.padding': '0 10px',
        'month.moreViewList.padding': '10px'
      };

      var templates = {
        milestone: function(schedule) {
          return '<span class="calendar-font-icon ic-milestone-b"></span> <span style="background-color: ' + schedule.bgColor + '">' + schedule.title + '</span>';
      },
      milestoneTitle: function() {
          return '<span class="tui-full-calendar-left-content">MILESTONE</span>';
      },
      task: function(schedule) {
          return '#' + schedule.title;
      },
      taskTitle: function() {
          return '<span class="tui-full-calendar-left-content">TASK</span>';
      },
      allday: function(schedule) {
          return getTimeTemplate(schedule, true);
      },
      alldayTitle: function() {
          return '<span class="tui-full-calendar-left-content">ALL DAY</span>';
      },
      time: function(schedule) {
          return '<strong>' + moment(schedule.start.getTime()).format('HH:mm') + '</strong> ' + schedule.title;
      },
      goingDuration: function(schedule) {
          return '<span class="calendar-icon ic-travel-time"></span>' + schedule.goingDuration + 'min.';
      },
      comingDuration: function(schedule) {
          return '<span class="calendar-icon ic-travel-time"></span>' + schedule.comingDuration + 'min.';
      },
      monthMoreTitleDate: function(date, dayname) {
          var day = date.split('.')[2];

          return '<span class="tui-full-calendar-month-more-title-day">' + day + '</span> <span class="tui-full-calendar-month-more-title-day-label">' + dayname + '</span>';
      },
      monthMoreClose: function() {
          return '<span class="tui-full-calendar-icon tui-full-calendar-ic-close"></span>';
      },
      monthGridHeader: function(dayModel) {
          var date = parseInt(dayModel.date.split('-')[2], 10);
          var classNames = ['tui-full-calendar-weekday-grid-date '];

          if (dayModel.isToday) {
              classNames.push('tui-full-calendar-weekday-grid-date-decorator');
          }

          return '<span class="' + classNames.join(' ') + '">' + date + '</span>';
      },
      monthGridHeaderExceed: function(hiddenSchedules) {
          return '<span class="weekday-grid-more-schedules">+' + hiddenSchedules + '</span>';
      },
      monthGridFooter: function() {
          return '';
      },
      monthGridFooterExceed: function(hiddenSchedules) {
          return '';
      },
      monthDayname: function(model) {
          return (model.label).toString().toLocaleUpperCase();
      },
      weekDayname: function(model) {
          return '<span class="tui-full-calendar-dayname-date">' + model.date + '</span>&nbsp;&nbsp;<span class="tui-full-calendar-dayname-name">' + model.dayName + '</span>';
      },
      weekGridFooterExceed: function(hiddenSchedules) {
          return '+' + hiddenSchedules;
      },
      dayGridTitle: function(viewName) {

          // use another functions instead of 'dayGridTitle'
          // milestoneTitle: function() {...}
          // taskTitle: function() {...}
          // alldayTitle: function() {...}

          var title = '';
          switch(viewName) {
              case 'milestone':
                  title = '<span class="tui-full-calendar-left-content">MILESTONE</span>';
                  break;
              case 'task':
                  title = '<span class="tui-full-calendar-left-content">TASK</span>';
                  break;
              case 'allday':
                  title = '<span class="tui-full-calendar-left-content">ALL DAY</span>';
                  break;
          }

          return title;
      },
      schedule: function(schedule) {

          // use another functions instead of 'schedule'
          // milestone: function() {...}
          // task: function() {...}
          // allday: function() {...}

          var tpl;

          switch(category) {
              case 'milestone':
                  tpl = '<span class="calendar-font-icon ic-milestone-b"></span> <span style="background-color: ' + schedule.bgColor + '">' + schedule.title + '</span>';
                  break;
              case 'task':
                  tpl = '#' + schedule.title;
                  break;
              case 'allday':
                  tpl = getTimeTemplate(schedule, true);
                  break;
          }

          return tpl;
      },
      collapseBtnTitle: function() {
          return '<span class="tui-full-calendar-icon tui-full-calendar-ic-arrow-solid-top"></span>';
      },
      timezoneDisplayLabel: function(timezoneOffset, displayLabel) {
          var gmt, hour, minutes;

          if (!displayLabel) {
              gmt = timezoneOffset < 0 ? '-' : '+';
              hour = Math.abs(parseInt(timezoneOffset / 60, 10));
              minutes = Math.abs(timezoneOffset % 60);
              displayLabel = gmt + getPadStart(hour) + ':' + getPadStart(minutes);
          }

          return displayLabel;
      },
      timegridDisplayPrimayTime: function(time) {
          // will be deprecated. use 'timegridDisplayPrimaryTime'
          var meridiem = 'am';
          var hour = time.hour;

          if (time.hour > 12) {
              meridiem = 'pm';
              hour = time.hour - 12;
          }

          return hour + ' ' + meridiem;
      },
      timegridDisplayPrimaryTime: function(time) {
          var meridiem = 'am';
          var hour = time.hour;

          if (time.hour > 12) {
              meridiem = 'pm';
              hour = time.hour - 12;
          }

          return hour + ' ' + meridiem;
      },
      timegridDisplayTime: function(time) {
          return getPadStart(time.hour) + ':' + getPadStart(time.hour);
      },
      timegridCurrentTime: function(timezone) {
          var templates = [];

          if (timezone.dateDifference) {
              templates.push('[' + timezone.dateDifferenceSign + timezone.dateDifference + ']<br>');
          }

          templates.push(moment(timezone.hourmarker).format('HH:mm a'));

          return templates.join('');
      },
      popupIsAllDay: function() {
          return 'All Day';
      },
      popupStateFree: function() {
          return 'Free';
      },
      popupStateBusy: function() {
          return 'Busy';
      },
      titlePlaceholder: function() {
          return 'Subject';
      },
      locationPlaceholder: function() {
          return 'Location';
      },
      startDatePlaceholder: function() {
          return 'Start date';
      },
      endDatePlaceholder: function() {
          return 'End date';
      },
      popupSave: function() {
          return 'Save';
      },
      popupUpdate: function() {
          return 'Update';
      },
      popupDetailDate: function(isAllDay, start, end) {
          var isSameDate = moment(start).isSame(end);
          var endFormat = (isSameDate ? '' : 'YYYY.MM.DD ') + 'hh:mm a';

          if (isAllDay) {
              return moment(start).format('YYYY.MM.DD') + (isSameDate ? '' : ' - ' + moment(end).format('YYYY.MM.DD'));
          }

          return (moment(start).format('YYYY.MM.DD hh:mm a') + ' - ' + moment(end).format(endFormat));
      },
      popupDetailLocation: function(schedule) {
          return 'Location : ' + schedule.location;
      },
      popupDetailUser: function(schedule) {
          return 'User : ' + (schedule.attendees || []).join(', ');
      },
      popupDetailState: function(schedule) {
          return 'State : ' + schedule.state || 'Busy';
      },
      popupDetailRepeat: function(schedule) {
          return 'Repeat : ' + schedule.recurrenceRule;
      },
      popupDetailBody: function(schedule) {
          return 'Body : ' + schedule.body;
      },
      popupEdit: function() {
          return 'Edit';
      },
      popupDelete: function() {
          return 'Delete';
      }
    };











    cal = new tui.Calendar(document.getElementById('calendar'), {
        defaultView: 'month',
        taskView: false,    // Can be also ['milestone', 'task']
        scheduleView: true,  // Can be also ['allday', 'time']
        theme: MONTHLY_CUSTOM_THEME, // set theme
        //template: templates,
        useCreationPopup: true,
        useDetailPopup: true,
        scheduleFilter: function(schedule) {
          return Boolean(schedule.isVisible);
      },
        month: {
            daynames: lang[current_lang].daynames,
            startDayOfWeek:1,
            narrowWeekend: false
        },
        week: {
            daynames: lang[current_lang].daynames,
            startDayOfWeek: 1,
            narrowWeekend: false
        },/*
        timezone: {
            zones: [
                {
                  timezoneName: 'Asia/Seoul',
                  tooltip: 'Seoul',
                  displayLabel: 'GMT+09:00'
                },
                {
                  timezoneName: 'America/New_York',
                  tooltip: 'New York',
                  displayLabel: 'GMT-05:00'
                },
            ]
        },*/
        
    });


/*     cal.on({
      'clickTimezonesCollapseBtn': function(timezonesCollapsed) {
        if (timezonesCollapsed) {
          cal.setTheme({
            'week.daygridLeft.width': '77px',
            'week.timegridLeft.width': '77px'
          });
        } else {
          cal.setTheme({
            'week.daygridLeft.width': '60px',
            'week.timegridLeft.width': '60px'
          });
        }
    
        return true;
      }
    });

 */

    init();

}


function init() {
  cal.setCalendars(CalendarList);

  setRenderRangeText();
  setSchedules();
  //setEventListener();

}

//ANTON

function changeCalendarView(view){
  cal.changeView(view);
}



//TUI

function getTimeTemplate(schedule, isAllDay) {
  var html = [];

  if (!isAllDay) {
    html.push('<strong>' + moment(schedule.start.getTime()).format('HH:mm') + '</strong> ');
  }
  if (schedule.isPrivate) {
    html.push('<span class="calendar-font-icon ic-lock-b"></span>');
    html.push(' Private');
  } else {
    if (schedule.isReadOnly) {
      html.push('<span class="calendar-font-icon ic-readonly-b"></span>');
    } else if (schedule.recurrenceRule) {
      html.push('<span class="calendar-font-icon ic-repeat-b"></span>');
    } else if (schedule.attendees.length) {
      html.push('<span class="calendar-font-icon ic-user-b"></span>');
    } else if (schedule.location) {
      //html.push('<span class="calendar-font-icon ic-location-b"></span>');
    }
    html.push(' ' + schedule.title);
  }

  return html.join('');
}

function getGridTitleTemplate(type) {
  var title = '';

  switch(type) {
    case 'milestone':
      title = '<span class="tui-full-calendar-left-content">MILESTONE</span>';
      break;
    case 'task':
      title = '<span class="tui-full-calendar-left-content">TASK</span>';
      break;
    case 'allday':
      title = '<span class="tui-full-calendar-left-content">ALL DAY</span>';
      break;
  }

  return title;
}

function getGridCategoryTemplate(category, schedule) {
  var tpl;

  switch(category) {
    case 'milestone':
      tpl = '<span class="calendar-font-icon ic-milestone-b"></span> <span style="background-color: ' + schedule.bgColor + '">' + schedule.title + '</span>';
      break;
    case 'task':
      tpl = '#' + schedule.title;
      break;
    case 'allday':
      tpl = getTimeTemplate(schedule, true);
      break;
  }

  return tpl;
}















function getDataAction(target) {
  return target.dataset ? target.dataset.action : target.getAttribute('data-action');
}

function setDropdownCalendarType() {
  var calendarTypeName = document.getElementById('calendarTypeName');
  var calendarTypeIcon = document.getElementById('calendarTypeIcon');
  var options = cal.getOptions();
  var type = cal.getViewName();
  var iconClassName;

  if (type === 'day') {
    type = 'Daily';
    iconClassName = 'calendar-icon ic_view_day';
  } else if (type === 'week') {
    type = 'Weekly';
    iconClassName = 'calendar-icon ic_view_week';
  } else if (options.month.visibleWeeksCount === 2) {
    type = '2 weeks';
    iconClassName = 'calendar-icon ic_view_week';
  } else if (options.month.visibleWeeksCount === 3) {
    type = '3 weeks';
    iconClassName = 'calendar-icon ic_view_week';
  } else {
    type = 'Monthly';
    iconClassName = 'calendar-icon ic_view_month';
  }

  calendarTypeName.innerHTML = type;
  calendarTypeIcon.className = iconClassName;
}

function onClickMenu(e) {
  var target = jQuery(e.target).closest('a[role="menuitem"]')[0];
  var action = getDataAction(target);
  var options = cal.getOptions();
  var viewName = '';

  switch (action) {
    case 'toggle-daily':
      viewName = 'day';
      break;
    case 'toggle-weekly':
      viewName = 'week';
      break;
    case 'toggle-monthly':
      options.month.visibleWeeksCount = 0;
      viewName = 'month';
      break;
    case 'toggle-weeks2':
      options.month.visibleWeeksCount = 2;
      viewName = 'month';
      break;
    case 'toggle-weeks3':
      options.month.visibleWeeksCount = 3;
      viewName = 'month';
      break;
    case 'toggle-narrow-weekend':
      options.month.narrowWeekend = !options.month.narrowWeekend;
      options.week.narrowWeekend = !options.week.narrowWeekend;
      viewName = cal.getViewName();

      target.querySelector('input').checked = options.month.narrowWeekend;
      break;
    case 'toggle-start-day-1':
      options.month.startDayOfWeek = options.month.startDayOfWeek ? 0 : 1;
      options.week.startDayOfWeek = options.week.startDayOfWeek ? 0 : 1;
      viewName = cal.getViewName();

      target.querySelector('input').checked = options.month.startDayOfWeek;
      break;
    case 'toggle-workweek':
      options.month.workweek = !options.month.workweek;
      options.week.workweek = !options.week.workweek;
      viewName = cal.getViewName();

      target.querySelector('input').checked = !options.month.workweek;
      break;
    default:
      break;
  }

  cal.setOptions(options, true);
  cal.changeView(viewName, true);

  setDropdownCalendarType();
  setRenderRangeText();
  setSchedules();
}

function onClickNavi(e) {
  var action = getDataAction(e.target);

  switch (action) {
    case 'move-prev':
      cal.prev();
      break;
    case 'move-next':
      cal.next();
      break;
    case 'move-today':
      cal.today();
      break;
    default:
      return;
  }

  setRenderRangeText();
  setSchedules();
}

function setRenderRangeText() {
  var renderRange = document.getElementById('renderRange');
  var options = cal.getOptions();
  var viewName = cal.getViewName();
  var html = [];
  if (viewName === 'day') {
    html.push(moment(cal.getDate().getTime()).format('YYYY.MM.DD'));
  } else if (viewName === 'month' &&
    (!options.month.visibleWeeksCount || options.month.visibleWeeksCount > 4)) {
    html.push(moment(cal.getDate().getTime()).format('YYYY.MM'));
  } else {
    html.push(moment(cal.getDateRangeStart().getTime()).format('YYYY.MM.DD'));
    html.push(' ~ ');
    html.push(moment(cal.getDateRangeEnd().getTime()).format(' MM.DD'));
  }
  renderRange.innerHTML = html.join('');
}

function setSchedules() {
  cal.clear();
  generateSchedule(cal.getViewName(), cal.getDateRangeStart(), cal.getDateRangeEnd());
  cal.createSchedules(ScheduleList);
  refreshScheduleVisibility();
}


function refreshScheduleVisibility() {
  var calendarElements = Array.prototype.slice.call(document.querySelectorAll('#calendarList input'));

  CalendarList.forEach(function(calendar) {
    cal.toggleSchedules(calendar.id, !calendar.checked, false);
  });

  cal.render(true);

  calendarElements.forEach(function(input) {
    var span = input.nextElementSibling;
    span.style.backgroundColor = input.checked ? span.style.borderColor : 'transparent';
  });
}

/* resizeThrottled = tui.util.throttle(function() {
  cal.render();
}, 50);

function setEventListener() {
  $('.dropdown-menu a[role="menuitem"]').on('click', onClickMenu);
  $('#menu-navi').on('click', onClickNavi);
  window.addEventListener('resize', resizeThrottled);
} */


