<?php
/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2025 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace Jtotal\Jtfw\Fields;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Registry\Registry;

class JtAccordionField extends FormField
{
    protected $type = 'JtAccordion';

    protected function getLabel()
    {
        return '';
    }

    protected function getInput()
    {

        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();







        $wa->addInlineScript("



        
            document.addEventListener('DOMContentLoaded', function() {


                if((typeof jt_accordion_initialized) !== 'undefined') return;
                
                const accordionCollapseElements = document.querySelectorAll('.accordion-collapse');

                // Loop through each accordion-collapse element
                accordionCollapseElements.forEach((accordionCollapseElement, index) => {

                    const padre = accordionCollapseElement.parentElement;
                    const hijos = padre.querySelectorAll('.control-group');

                    hijos.forEach((siblingElement) => {
                        accordionCollapseElement.querySelector('.accordion-body').appendChild(siblingElement);
                    });
                });

                jt_accordion_initialized = true;
            });

        ");

        $field_set = $this->form->getFieldset();

        $params = new Registry($this->form->getValue('params'));
        $jt_active_accordeons = $params->get('jt_active_accordeons', '');

        $id = ($this->element['id'] === null) ? '' : strtolower($this->element['id']);
        $mode = ($this->element['mode'] === null) ? '' : strtolower($this->element['mode']);

        $initial = ($this->element['initial'] === null) ? '' : strtolower($this->element['initial']);
        $label = ($this->element['label'] === null) ? '' : strtolower($this->element['label']);
        $slide = ($this->element['slide'] === null) ? '' : strtolower($this->element['slide']);
        $acordeon = ($this->element['acordeon'] === null) ? '' : strtolower($this->element['acordeon']);

        $active_default = ($this->element['active'] === null) ? '' : strtolower($this->element['active']);
        //$active = ($this->value == NULL) ? $active : $this->value;

        if ($initial == 'true') {
            if (is_array(json_decode($jt_active_accordeons))) {
                $active = (in_array($active_default, json_decode($jt_active_accordeons))) ? $active_default : '';
            } else {
                $active = '';
            }

            $accStart = HTMLHelper::_('bootstrap.startAccordion', $acordeon, array('active' => $active));
            return $accStart;
        } elseif ($initial == 'slide') {
            $slider = HTMLHelper::_('bootstrap.addSlide', $acordeon, Text::_($label), $slide, "buf_accordion_item");
            return $slider;
        } elseif ($initial == 'end') {
            $end = HTMLHelper::_('bootstrap.endSlide');
            return $end;
        } elseif ($initial == 'superend') {
            $superend = HTMLHelper::_('bootstrap.endAccordion');
            return $superend;
        }
    }
}
