<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2020 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace Jtotal\Jtfw\Fields;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Filesystem\Folder;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

class JtClearCacheField extends FormField
{
    protected $type = 'JtClearCache';
    protected $directory;

    protected function getLabel()
    {
        //return "asdf";
    }

    protected function getInput()
    {

        $fV = '';


        $path =  ((bool) $this->element['path']) ? $this->element['path'] : 'cache';
        $cache_path_abs = JPATH_SITE . '/'. $path .'/' . $this->element['directory'];

        $disabled = 'disabled';
        $countFiles = '0';
        if (Folder::exists($cache_path_abs)) {
            $disabled = '';
            $countFiles = count(Folder::files($cache_path_abs));

        } else {
            return '<a class="btn btn-link btn-light  position-relative ' . $disabled . '" id="jt_clearCache" onClick="JTClearCache()">' . Text::_('JT_CLEAR_CACHE') . '
            <span id="jt_clearCache_pill" class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
            ' . $countFiles . '
            <span class="visually-hidden">files</span>
            </span></a>';
        }

        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();

        $fV .= '<a class="btn btn-secondary btn-light  position-relative ' . $disabled . '" id="jt_clearCache" onClick="JTClearCache()">' . Text::_('JT_CLEAR_CACHE') . '
        <span id="jt_clearCache_pill" class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
        ' . $countFiles . '
        <span class="visually-hidden">files</span>
        </span></a>';

        $script = "

        async function postData(url = '') {
            const response = await fetch(url, {
                method: 'POST',
                mode: 'cors',
                cache: 'no-cache',
                credentials: 'same-origin',
                headers: {
                  'Content-Type': 'application/json'
                }
              });
            return response.json();
        }

        function JTClearCache(){
            postData('" . Uri::root() . "index.php?option=com_ajax&group=system&plugin=JTFramework&task=ClearCache&directory=" . $this->element['directory'] . "&format=json')
            .then(data => {
              console.log(data.data[0]);
              if(data.data[0] === true){
                document.getElementById('jt_clearCache').classList.add('disabled');
                document.getElementById('jt_clearCache_pill').classList.add('hide');
                document.getElementById('jt_clearCache_pill').innerHTML = 0;
              }
            });
        }

       ";
        $wa->addInlineScript($script);

        return $fV;
    }
}
