<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2023 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

namespace Jtotal\Jtfw\Fields;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ColorField;
use Joomla\CMS\HTML\HTMLHelper;
use JTFramework\JTfunc;

class JtColorField extends ColorField
{
    /**
     * The form field type.
     *
     * @var    string
     * @since  11.1
     */

    protected $type = 'JtColor';
    protected $context;
    protected $format = 'hex';
    protected $append = false;
    protected $fa = '';
    protected $append_onclick = '';
    protected $validate = 'color';
    protected $placeholder = '';

    protected $keywords = '';
    protected $class = '';
    protected $prepend = false;
    protected $append_class = 'btn btn-link';

    protected function getInput()
    {


        if (JTfunc::isJ4()) {
            return $this->getInputJ4();
        } else {
            return $this->getInputJ3();
        }
    }

    protected function getInputJ4()
    {

        $this->prepend = isset($this->element['prepend']) ? filter_var((string) $this->element['prepend']) : (bool) false;
        $this->append = isset($this->element['append']) ? filter_var((string) $this->element['append'], FILTER_VALIDATE_BOOLEAN) : (bool) false;
        $this->fa = isset($this->element['fa']) ? (string) $this->element['fa'] : '';
        $this->append_onclick = isset($this->element['append_onclick']) ? (string) $this->element['append_onclick'] : '';
        $this->append_class = isset($this->element['append_class']) ? (string) $this->element['append_class'] : 'btn btn-link';

        if ($this->validate !== 'color' && in_array($this->format, array('rgb', 'rgba'), true)) {
            $alpha = ($this->format === 'rgba');
            $this->placeholder = $alpha ? 'rgba(0, 0, 0, 0.5)' : 'rgb(0, 0, 0)';
        } else {
            $placeholder = '#rrggbb';
        }

        $inputclass = ($this->keywords && !in_array($this->format, array('rgb', 'rgba'), true)) ? ' keywords' : ' ' . $this->format;
        $class = 'tmtype="color" class="tmvalor form-control ' . trim('minicolors ' . $this->class) . ($this->validate === 'color' ? '' : $inputclass) . '"';
        $control = $this->control ? ' data-control="' . $this->control . '"' : '';
        $format = $this->format ? ' data-format="' . $this->format . '"' : '';
        $keywords = $this->keywords ? ' data-keywords="' . $this->keywords . '"' : '';
        $colors = $this->colors ? ' data-colors="' . $this->colors . '"' : '';
        $validate = $this->validate ? ' data-validate="' . $this->validate . '"' : '';
        $disabled = $this->disabled ? ' disabled' : '';
        $readonly = $this->readonly ? ' readonly' : '';
        //$hint         = strlen($this->hint) ? ' placeholder="' . $this->hint . '"' : ' placeholder="' . $this->placeholder . '"';
        $autocomplete = !empty($autocomplete) ? 'autocomplete="' . $autocomplete . '"' : '';

        // Force LTR input value in RTL, due to display issues with rgba/hex colors
        $direction = Factory::getApplication()->getLanguage()->isRtl() ? ' dir="ltr" style="text-align:right"' : '';

        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
        $wa->usePreset('minicolors')
            ->useScript('field.color-adv');

        $return = '';

        if ($this->append) {
            $return .= '<div class="tm_input-append input-append input-group">';
        }

        if (!$this->append) {
            $return .= '<div class="tm_input-append input-group">';
        }

        if ($this->prepend) {
            $return .= '<span class="tmgrouped_prepend">' . $this->prepend . ' </span>';
        }

        $return .= '
            <input type="text" name="' . $this->name . '" id="' . $this->id . '" value="' . $this->value . '" ';
        $return .= $class;
        $return .= $control;
        $return .= $readonly;
        $return .= $disabled;
        $return .= $this->required;
        $return .= $this->onchange;
        $return .= $autocomplete;
        $return .= $this->autofocus;
        $return .= $format;
        $return .= $keywords;
        $return .= $direction;
        $return .= $validate;
        $return .= $this->dataAttribute;
        $return .= '/>';

        if ($this->append) {
            $return .= '<a class="' . $this->append_class . '" onclick="' . $this->append_onclick . '"> <i class="' . $this->fa . '"></i> </a>';
        }

        $return .= '</div>';

        return $return;
    }

    protected function getInputJ3()
    {
        // Include jQuery
        // Including fallback code for HTML5 non supported browsers.

        HTMLHelper::_('jquery.framework');
        HTMLHelper::_('script', 'system/html5fallback.js', array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));
        HTMLHelper::_('script', 'jui/jquery.minicolors.min.js', array('version' => 'auto', 'relative' => true));
        HTMLHelper::_('stylesheet', 'jui/jquery.minicolors.css', array('version' => 'auto', 'relative' => true));
        HTMLHelper::_('script', 'system/color-field-adv-init.min.js', array('version' => 'auto', 'relative' => true));

        $this->prepend = isset($this->element['prepend']) ? filter_var((string) $this->element['prepend']) : (bool) false;
        $this->append = isset($this->element['append']) ? filter_var((string) $this->element['append'], FILTER_VALIDATE_BOOLEAN) : (bool) false;
        $this->fa = isset($this->element['fa']) ? (string) $this->element['fa'] : '';
        $this->append_onclick = isset($this->element['append_onclick']) ? (string) $this->element['append_onclick'] : '';
        $this->append_class = isset($this->element['append_class']) ? (string) $this->element['append_class'] : 'btn btn-default';

        $return = '';

        if ($this->append) {
            $return .= '<div class="tm_input-append input-append input-group">';
        }

        if (!$this->append) {
            $return .= '<div class="tm_input-append input-group">';
        }

        if ($this->prepend) {
            $return .= '<span class="tmgrouped_prepend">' . $this->prepend . ' </span>';
        }

        $return .= '<input
            type="text"
            name="' . $this->name . '"
            value="' . $this->value . '"
            placeholder="#rrggbb"
            class="tmvalor minicolors minicolors-input"
            data-position="bottom left"
            data-control="hue"
            data-format="rgba"
            size="25"
            aria-invalid="false"
            tmtype="color"
            data-opacity="1">';

        if ($this->append) {
            $return .= '<a class="' . $this->append_class . '" onclick="' . $this->append_onclick . '"> <i class="' . $this->fa . '"></i> </a>';
        }

        $return .= '</div>';

        return $return;
    }
}
