<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2023 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace Jtotal\Jtfw\Fields;

defined('_JEXEC') or die;

use Joomla\Archive\Archive;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Filesystem\File;

class JtExportField extends FormField
{
    protected $type = 'JtExport';

    protected function getLabel(): string
    {
        $this->label = isset($this->element['label']) ? (string) Text::_($this->element['label']) : '';
        return $this->label;
    }

    protected function getInput(): string
    {
        $onchange = $this->onchange ? ' onchange="' . $this->onchange . '"' : '';
        $id = $this->id;
        $this->default = (string) ($this->element['default'] ?? '0');
        $this->value = ($this->value ?: $this->default);

        $input = '<script>function jtexport_' . $id . '(el,id){}</script>';

        $app = Factory::getApplication();

        $file = [
            'json' => [
                'name' => $this->id . '.json',
                'data' => json_encode($this->form->getData()),
                'time' => time(),
                'mime' => 'application/json',
            ],
        ];

        $ziproot = $app->get('tmp_path') . '/' . $this->id . '.zip';

        $export = '';
        $export .= '<a onclick="document.querySelector(\'#' . $this->id . '\').value = 1; Joomla.submitbutton(\'module.apply\');" class="btn btn-success tmexport">' . Text::_('JTFW_EXPORT') . '</a> ';

        if (version_compare(JVERSION, '5.4', '>=')) {
            if (\Joomla\Filesystem\File::exists($ziproot) && $this->value != 0) {
                $export .= ' <a onclick="Joomla.submitbutton(\'module.apply\');" class="tmexport_file btn btn-link" target="_blank" href="' . Uri::root() . 'tmp/' . $this->id . '.zip">' . $this->id . '.zip</a>';
            }
        }else{
            if (\Joomla\CMS\Filesystem\File::exists($ziproot) && $this->value != 0) {
                $export .= ' <a onclick="Joomla.submitbutton(\'module.apply\');" class="tmexport_file btn btn-link" target="_blank" href="' . Uri::root() . 'tmp/' . $this->id . '.zip">' . $this->id . '.zip</a>';
            }
        }




        if ($this->value != 0) {
            $this->value = 0;

            $archive = new Archive();
            $packager = $archive->getAdapter('zip');

            if (!$packager || !$packager->create($ziproot, $file)) {
                $export .= 'ZIP creation error';
            }
        }

        $export .= '<input type="hidden" name="' . $this->name . '" id="' . $this->id . '" value="' . $this->value . '"' . $onchange . ' />';

        return $export;
    }
}
