<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2023 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace Jtotal\Jtfw\Fields;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Form\FormField;
use SimpleXMLElement;

//jimport('joomla.form.form');
/*
if (is_file(JPATH_PLUGINS . '/system/jtframework/autoload.php')) {
    require_once JPATH_PLUGINS . '/system/jtframework/autoload.php';
} else {
    $app = Factory::getApplication();
    $app->enqueueMessage(Text::_('JT_FW_NOT_FOUND'), 'error');
    return;
}
 */
class JtHoursField extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     * @since  11.1
     */
    protected $type = 'jthours';

    protected $style = '';
    protected $hours = 'true';
    protected $show_time = 'false';
    protected $hours_step = '0';
    protected $max_hours = '';
    protected $minutes = 'true';
    protected $minutes_step = '0';
    protected $seconds = 'true';
    protected $seconds_step = '0';


    protected function getLabel()
    {

        $this->label = isset($this->element['label']) ? (string) Text::_($this->element['label']) : '';

        //return $this->label;
        return $this->label;
    }

    protected function getInput()
    {

        $this->hours = (string) $this->element['hours'] ? (string) $this->element['hours'] : 'true';

        $this->show_time = (string) $this->element['show_time'] ? (string) $this->element['show_time'] : 'false';

        $this->hours_step = (string) $this->element['hours_step'] ? (string) $this->element['hours_step'] : '0';
        $this->max_hours = (string) $this->element['max_hours'] ? (string) $this->element['max_hours'] : '';
        $this->minutes = (string) $this->element['minutes'] ? (string) $this->element['minutes'] : 'true';
        $this->minutes_step = (string) $this->element['minutes_step'] ? (string) $this->element['minutes_step'] : '0';
        $this->seconds = (string) $this->element['seconds'] ? (string) $this->element['seconds'] : 'true';
        $this->seconds_step = (string) $this->element['seconds_step'] ? (string) $this->element['seconds_step'] : '0';

        $this->style = (string) $this->element['style'] ? ' style="' . (string) $this->element['style'] . '"' : '';

        $onchange = $this->onchange ? ' onchange="' . $this->onchange . '"' : '';

        $name = $this->name;
        $id = $this->id;
        $this->default = (string) $this->element['default'] ? (string) $this->element['default'] : '00:00:00';
        $this->value = ($this->value ?: $this->default);

        $input = '<script>function jtchangehour_' . $id . '(el,id){
            var parent = "";
            //jform_com_fields__jtroutemap2__jform_com_fields__jtroutemap2__jtroutemap_hours2__jthourshour
            if(el=="h"){
                var parent = id.replace(\'__jthourshour_input\',\'\');
                parent = parent.replace(\'__jthourshour\',\'\');
            }

            if(el=="m"){
                var parent = id.replace(\'__jthoursmin_input\',\'\');
                parent = parent.replace(\'__jthoursmin\',\'\');
            }

            if(el=="s"){
                var parent = id.replace(\'__jthoursec_input\',\'\');
                parent = parent.replace(\'__jthoursec\',\'\');
            }
            var hour = "0";
            var min = "00";
            var sec = "00";
        ';

        $view_hours = '""';
        $view_minutes = '""';
        $view_seconds = '""';

        if ($this->hours == 'true') {
            $input .= 'var hour = document.querySelector("#"+parent+"__jthourshour_input").value;';
            $view_hours = 'hour';
        }

        if ($this->minutes == 'true') {
            $input .= 'var min = parseInt(document.querySelector("#"+parent+"__jthoursmin_input").value);';

            $input .= 'if(isNaN(min)) min=00;';
            $input .= 'if(min>=60) min=59;';
            $view_minutes = '":" + String(min).padStart(2, "0")';
        }

        if ($this->seconds == 'true') {
            $view_seconds = '":" + String(sec).padStart(2, "0")';
            $input .= 'var sec = document.querySelector("#"+parent+"__jthoursec_input").value;';
        }

        $input .= '

            //let current_datetime = new Date(\'2000-01-01 \'+hour+\':\'+min+\':\'+sec);
            var complete = ' . $view_hours . ' + ' . $view_minutes . ' + ' . $view_seconds . ';
            document.querySelector("#' . $id . '").value = complete;
            //document.querySelector("#' . $id . '_clock").value = complete;


        }</script>';

        $input .= '<div ' . $this->style . ' class="jthours span12">';
        //$input .= '<span class="input-prepend">';
        //$input .= '<span class="add-on">as</span>';
        /* $input .= '<input
        type="text"
        disable
        name="'.$this->name.'"
        id="'.$this->id.'"
        value="'.$this->value.'"
        '. $onchange .'
        />'; */
        //$input .= '</span>';

        $hour_array = explode(':', $this->value);
        $hours_final = isset($hour_array[0]) ? $hour_array[0] : '0';
        $min_final = isset($hour_array[1]) ? $hour_array[1] : '00';
        $sec_final = isset($hour_array[2]) ? $hour_array[2] : '00';

        //HOURS
        if ($this->hours == 'true') {
            $field = new SimpleXMLElement('<field class="span6" name="' . $name . '_jthourshour"  step="' . $this->hours_step . '" onchange="jtchangehour_' . $id . '(\'h\',this.id);" type="tmrange" max="' . $this->max_hours . '" append="H" size="3" value="' . $hours_final . '" default="' . $hours_final . '"/>');
            $this->form->setField($field);
            $input .= $this->form->getInput($name . '_jthourshour');
        }

        //MINUTES
        if ($this->minutes == 'true') {
            $field = new SimpleXMLElement('<field class="span6" name="' . $this->name . '_jthoursmin"  step="' . $this->minutes_step . '" onchange="jtchangehour_' . $id . '(\'m\',this.id);" type="tmrange" max="59" append="M" value="' . $min_final . '" size="3" default="' . $min_final . '"/>');
            $this->form->setField($field);
            $input .= $this->form->getInput($this->name . '_jthoursmin');
        }

        //SECONDS
        if ($this->seconds == 'true') {
            $field = new SimpleXMLElement('<field class="span4" name="' . $this->name . '_jthoursec" step="' . $this->seconds_step . '" onchange="jtchangehour_' . $id . '(\'s\',this.id);" type="tmrange" max="59" append="S" size="3" default="' . $sec_final . '"/>');
            $this->form->setField($field);
            $input .= $this->form->getInput($this->name . '_jthoursec');
        }

        if ($this->show_time == 'true') {
            $input .= '<span class="jthours_clock input-prepend">
                                <span class="add-on"><i class="fas fa-stopwatch"></i></span>
                                <input
                                    type="text"
                                    class="input-mini"
                                    disable
                                    name="' . $this->name . '"
                                    id="' . $this->id . '"
                                    value="' . $this->value . '"
                                    ' . $onchange . '
                                />
                            </span>';
        } else {
            $input .= '<input
                                type="hidden"
                                size="3"
                                disable
                                name="' . $this->name . '"
                                id="' . $this->id . '"
                                value="' . $this->value . '"
                                ' . $onchange . '
                            />';
        }

        $input .= '</div>';

        return $input;
    }
}
