<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2020 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace Jtotal\Jtfw\Fields;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Jtotal\Jtfw\Helper\JtDebug;
use Jtotal\Jtfw\Helper\JtLicense;

class JtLicenseCheckField extends FormField
{
    protected $type = 'JtLicenseCheck';

    public $tiempo = '';
    public $error = array();

    // Añadido tipo de retorno string
    protected function getLabel(): string
    {
        $mode = $this->element['mode'];
        if ($mode == 'dashboard') {
            return ''; // Devolver string vacío en lugar de null
        }
        
        // Devolver string vacío por defecto
        return '';
    }

    // Añadido tipo de retorno string
    protected function getInput(): string
    {

        $valida = JtLicense::_checkLicense();

        $field_value = '';
        if ($valida) {
            /*PRO*/
            $field_value .= $this->pro();
        } else {
            /*LITE*/
            $field_value .= $this->lite();
        }

        $validaBool = ($valida) ? 1 : 0;
        $jsVar = 'const jtlicensecheck = ' . $validaBool . ';';

        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
        $wa->addInlineScript($jsVar);

        $field_value .= JtDebug::showDebug();
        $field_value .= '<input type="hidden" id="' . $this->id . '" name="' . $this->name . '" value="' . $validaBool . '"/>';

        return $field_value;
    }

    // Añadido tipo de retorno string
    private function lite(): string
    {
        return JtLicense::mensajeLITE();
    }

    // Añadido tipo de retorno string
    private function pro(): string
    {
        return JtLicense::mensajePRO();
    }
}
