<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2025 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace Jtotal\Jtfw\Fields;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;

/**
 * GET EXTENSION VERSION
 */
class JtVersionField extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     * @since  11.1
     */
    protected $type = 'JtVersion';

    protected function getLabel()
    {

        $return = '';

        if ($this->element['logotext'] && $this->element['logotext'] != '') {
            $return .= '<strong>'.$this->element['logotext'].'</strong>';
        }

        if ($this->element['logo'] && $this->element['logo'] != '') {
            $return .= '<img style="max-width:150px;" class="img-fluid img-fluid" src="' . $this->element['logo'] . '" alt="' . $this->element['element'] . '"/>';
        }
        if ($this->element['logo_dark'] && $this->element['logo_dark'] != '') {
            $return .= '<img style="max-width:150px; display: none;" class="img-fluid" src="' . $this->element['logo_dark'] . '" alt="' . $this->element['element'] . '"/>
            <style>
            @media (prefers-color-scheme: dark) {
                img[src="' . $this->element['logo'] . '"] { display: none !important; }
                img[src="' . $this->element['logo_dark'] . '"] { display: block !important; }
            }
            </style>';
        }
        return $return;
    }

    /**
     * Get the db version
     */

    protected function getInput()
    {

        $element = $this->element['element'];

        $prefers_color = //quiero saber la configuración de tema de joomla

        $user = Factory::getUser();
        $prefers_color = $user->getParam('admintemplate.color_scheme', 'auto');

        if (!$element) {
            return '<div class="alert alert-info">'
            . Text::_('JT_FW_ERROR_NOT_ELEMENT')
                . '</div>';
        }

        $db = Factory::getContainer()->get(\Joomla\Database\DatabaseInterface::class);
        
        try {
            $query = $db->getQuery(true)
            ->select($db->quoteName('manifest_cache'))
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('element') . ' = :element')
            ->bind(':element', $element);
            
            $result = $db->setQuery($query)->loadResult();
            
            if ($result) {
                $result = json_decode($result, false, 512, JSON_THROW_ON_ERROR);
            }
        } catch (\Exception $e) {
            Factory::getApplication()->enqueueMessage('Error loading extension data: ' . $e->getMessage(), 'error');
            $result = null;
        }

        $return = '';

        if ($result && isset($result->version)) {
            // Determine badge classes based on color scheme
            $badgeClass = 'badge';
            if ($prefers_color === 'dark') {
                $badgeClass .= ' bg-info text-dark';
            } elseif ($prefers_color === 'light') {
                $badgeClass .= ' bg-primary text-white';
            } else {
            // Auto mode - use CSS custom properties for better theme adaptation
                $badgeClass .= ' bg-primary';
            }
            
            $return .= '<span class="' . $badgeClass . ' me-2"><i class="fas fa-code-branch me-1"></i>Version: ' . $result->version . '</span>';
            $return .= '<span class="' . $badgeClass . '"><i class="fas fa-calendar-alt me-1"></i>' . $result->creationDate . '</span>';
        } else {
            $return .= '<div class="alert alert-warning">Extension version information not available</div>';
        }

        return $return;
    }
}
