<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2020 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace Jtotal\Jtfw\Fields;

defined('_JEXEC') or die;

use Joomla\CMS\Form\Field\RangeField;

class TmGroupedInputField extends RangeField
{
    /**
     * The form field type.
     *
     * @var    string
     * @since  11.1
     */
    protected $type = 'TmGroupedInputField';

    protected function getLabel()
    {

        $this->label = isset($this->element['label']) ? (string) $this->element['label'] : '';

        return $this->label;
    }

    protected function getInput()
    {
        $this->value = ($this->value ?: $this->default);

        $this->layout = 'tmgroupedinput';
        $parent = parent::getInput();

        return $parent;
    }

    protected function getLayoutPaths()
    {
        $paths = parent::getLayoutPaths();
        $paths[] = JPATH_PLUGINS . '/system/jtframework/layouts';
        //var_dump($paths);
        return $paths;
    }

    protected function getLayoutData()
    {
        $data = parent::getLayoutData();

        // Initialize some field attributes.
        $extraData = [
            'prepend' => isset($this->element['prepend']) ? (string) $this->element['prepend'] : '',
            'append' => isset($this->element['append']) ? (string) $this->element['append'] : '',
            'quantity' => isset($this->element['quantity']) ? (string) $this->element['quantity'] : '',
            'input_type' => isset($this->element['input_type']) ? (string) $this->element['input_type'] : '',
            'clone' => isset($this->element['clone']) ? (string) $this->element['clone'] : false,
            'title' => isset($this->element['title']) ? (string) $this->element['title'] : false,
        ];

        return array_merge($data, $extraData);
    }
}
