<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2020 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace Jtotal\Jtfw\Fields;

defined('_JEXEC') or die;

use Joomla\CMS\Form\Field\RangeField;
use Joomla\CMS\Language\Text;

class TmRangeField extends RangeField
{
    /**
     * The form field type.
     *
     * @var    string
     * @since  11.1
     */
    protected $type = 'TmRange';

    protected function getLabel()
    {

        $this->label = isset($this->element['label']) ? (string) Text::_($this->element['label']) : '';

        //return $this->label;
        return $this->label;
    }

    protected function getInput()
    {
        $this->value = (float) ($this->value ?: $this->default);

        if (!empty($this->max)) {
            $this->value = min($this->value, $this->max);
        }
        if (!empty($this->min)) {
            $this->value = max($this->value, $this->min);
        }

        $this->layout = 'tmrange';
        $parent = parent::getInput();

        return $parent;
    }

    protected function getLayoutPaths()
    {
        $paths = parent::getLayoutPaths();
        $paths[] = JPATH_PLUGINS . '/system/jtframework/layouts';
        //var_dump($paths);
        return $paths;
    }

    protected function getLayoutData()
    {
        $data = parent::getLayoutData();

        // Initialize some field attributes.
        $extraData = [
            'prepend' => isset($this->element['prepend']) ? (string) $this->element['prepend'] : '',
            'append' => isset($this->element['append']) ? (string) $this->element['append'] : '',
        ];

        return array_merge($data, $extraData);
    }
}
