<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2023 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace Jtotal\Jtfw\Helper;

use Joomla\CMS\Factory;
use Jtotal\Jtfw\Helper\JtFunc;

defined('_JEXEC') or die('Restricted access');

/**
 *  Fa Class
 */
class JtDebug
{
    /**
     *
     */
    private static $message = array();

    public static $startime;

    /*
    public function __construct($startime)
    {

    self::$startime = microtime(TRUE);
    }
     */

    /**
     * Undocumented function
     *
     * @param string $msg
     * @return void
     */
    public static function getDebug($msg = '')
    {

        $params = JtFunc::getParams();
        if ($params->get('jtdebug', 1)) {
            ob_start();
            var_dump($msg);
            $result = ob_get_clean();

            $app = Factory::getApplication();
            $app->enqueueMessage($result, 'JTdebug');
        }
    }

    public static function addDebug($name = '', $icon = '', $value = '', $startmicro = 0, $tr_class = '', $service = '')
    {

        $current_time = microtime(true);
        $totaltime = $current_time - self::$startime;

        self::$message[] = array('icon' => $icon, 'value' => $value, 'totaltime' => $totaltime * 10000, 'tr_class' => $tr_class, 'service' => $service);
    }

    public static function showDebug($force = false)
    {

        $params = JtFunc::getParams();
        if (!$params->get('jtdebug', 1) && !$force) {
            return;
        }

        $debug = '';
        $debug .= '<div class="table-responsive buf_debug"> <table class="table table-striped table-condensed table-sm">';

        foreach (self::$message as $key => $value) {
            if (!isset($anterior)) {
                $anterior = 0.0;
            }

            $actual = $value['totaltime'] - $anterior;

            $clase = ($actual <= 10) ? 'badge-success' : 'badge-warning';
            if ($actual >= 1000) {
                $clase = 'badge-danger';
            }

            $debug .= '<tr class="' . $value['tr_class'] . '">
				<td>' . $key . '</td>
				<td><i class="fas fa-' . $value['icon'] . '" aria-hidden="true"></i></td>
				<td><small>' . $value['service'] . '</small></td>
				<td>' . $value['value'] . '</td>
				<td><span class="badge">' . round($value['totaltime'], 2) . 'ms</span></td>
				<td><span class="badge ' . $clase . '">+' . round($actual, 3) . '</span></td>
			</tr>';

            $anterior = $value['totaltime'];
        }
        $debug .= '</table></div>';

        return $debug;
    }
}
