<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2023 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace Jtotal\Jtfw\Helper;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;

defined('_JEXEC') or die('Restricted access');


class JtFunc
{

    protected static $loaded = array();

    /**
     * get JTFramework params
     *
     * @return object
     */
    public static function getParams()
    {
        $plugin = PluginHelper::getPlugin('system', 'jtframework');
        $params = new Registry($plugin->params);

        return $params;
    }

    public static function isJ4()
    {
        // Define a helper constant to indicate whether we are on a Joomla 4 installation
        if (version_compare(JVERSION, '4.0', 'ge') && !defined('jtJ4')) {
            return true;
        }

        return false;
    }
    /**
     * Check if function is loaded
     * @param [type] $func
     * @return void
     */
    public static function functionLoaded($func)
    {

        if (in_array($func, self::$loaded)) {
            return true;
        } else {
            self::$loaded[] = $func;
            return false;
        }
    }

    /**
     * load custom scripts
     * @return bool
     */
    public static function getScript($path = '', $attribs = array('async' => 'async', 'crossorigin' => 'anonymous'))
    {
        if ($path == '') {
            return false;
        }

        $doc = Factory::getDocument();
        $wa = $doc->getWebAssetManager();
        $wa->registerAndUseScript(
            'promise',
            $path,
            [],
            $attribs
        );
        

        //$doc->addScript($path, array(), $attribs);

        JTdebug::addDebug('CustomScript', 'code', $path . ' loaded', microtime(true), 'table-info', basename(__FILE__, '.php'));
        return true;
    }

    /**
     * load custom scripts promises
     * @param [type] array
     * @return bool
     */
    public static function getPromiseScript($files = array(), $callback = '')
    {

        $js_array = json_encode($files);

        self::promiseScriptLoader();

        $script = 'Promise.all([';

        foreach ($files as $key => $file) {
            $script .= 'promiseLoad.js("' . $file . '")';
            if (count($files) != $key + 1) {
                $script .= ',';
            }
        }

        $script .= ']).then(function() {';

        if ($callback != '') {
            $script .= $callback . ';';
        }

        $script .= '}).catch(function(e) {
                console.log("Oh no, epic failure loading scripts!"+e);
            });';

        //Factory::getDocument()->addScriptDeclaration($script);

        $doc = Factory::getDocument();
        $wa = $doc->getWebAssetManager();
        $wa->addInlineScript($script);
    }

    /**
     * load custom scripts promises
     * * @return bool
     */
    public static function promiseScriptLoader()
    {

        if (self::functionLoaded('promiseScriptLoader')) {
            return;
        }
        $doc = Factory::getDocument();
        $wa = $doc->getWebAssetManager();
        $wa->addInlineScript("

         //PREFIED

            // Function which returns a function: https://davidwalsh.name/javascript-functions
            const promiseLoad = (function() {
                function _promiseLoad(tag) {
                return function(url) {
                    // This promise will be used by Promise.all to determine success or failure
                    return new Promise(function(resolve, reject) {
                    var element = document.createElement(tag);
                    var parent = 'body';
                    var attr = 'src';

                    // Important success and error for the promise
                    element.onload = function() {
                        resolve(url);
                    };
                    element.onerror = function() {
                        reject(url);
                    };

                    // Need to set different attributes depending on tag type
                    switch(tag) {
                        case 'script':
                        element.async = true;
                        break;
                        case 'link':
                        element.type = 'text/css';
                        element.rel = 'stylesheet';
                        attr = 'href';
                        parent = 'head';
                    }

                    // Inject into document to kick off loading
                    element[attr] = url;
                    document.addEventListener('DOMContentLoaded', function () {
                        document[parent].appendChild(element);
                    });

                    });
                };
                }

                return {
                    css: _promiseLoad('link'),
                    js: _promiseLoad('script'),
                    img: _promiseLoad('img')
                }
            })();

        ");
    }

    /***
     * get image size
     * *@return imagesize
     */
    public static function getImageInfo($img)
    {

        //paths
        if (substr($img, 0, 7) == "http://") {
            $final_img_to_size = $img;
        } elseif (substr($img, 0, 8) == "https://") {
            $final_img_to_size = $img;
        } elseif (substr($img, 0, 2) == "//") {
            $final_img_to_size = $img;
        } else {
            $final_img_to_size = JPATH_SITE . '/' . $img;
        }

        //mimetype
        $mime = mime_content_type($final_img_to_size);
        return getimagesize($final_img_to_size);
    }

    /**
     * @param string $path
     *
     * @return bool
     */
    public static function isAbsolute($path)
    {
        return isset(parse_url($path)['host']);
    }
}
