<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2020 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace Jtotal\Jtfw\Helper;

use InvalidArgumentException;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die('Restricted access');

/**
 *  Fonts Class
 */
class JtLicense
{

    public static $tiempo = '';
    public static $error = array();

    public function __construct()
    {
        //$this->error[] = "init";
    }

    public static function _checkLicense($email = '', $key = '', $product = '1')
    {

        //jt_fw_params
        $params = JtFunc::getParams();
        $email = $params->get('jtotal_email', '');
        $key = $params->get('jtkey', '');

        $session = Factory::getSession();

        if (!$session->get('JTkeycheck')) {
            $session->set('JTkeycheck', $key);
        }
        if (!$session->get('JTemailcheck')) {
            $session->set('JTemailcheck', $email);
        }
        if (!$session->get('JTlicensecheck')) {
            $session->set('JTlicensecheck', 0);
        }

        $valida = false;

        //CHECK EMPTY EMAIL AND JKEY
        if ($email == '' || $key == '') {
            $session->set('JTlicensecheck', 0);
            JtDebug::addDebug('FA53', 'code', 'Fa5 loaded', microtime(true), 'table-info', basename(__FILE__, '.php'));
            $valida = false;
        } else {
            $key_session = $session->get('JTkeycheck');
            $email_session = $session->get('JTemailcheck');
            $license_check = $session->get('JTlicensecheck');

            if ($key_session == $key && $email_session == $email) {
                if ($license_check == 1) {
                    //EVERYTHINK IS OK...

                    JtDebug::addDebug('Check returning user', 'check-circle', 'Everythink is fine', microtime(true), 'table-success', basename(__FILE__, '.php'));

                    return true;
                }
            }

            //KEY != SESSION
            if ($key_session != $key || $email_session != $email) {
                $session->set('JTlicensecheck', 0);
                //$session->set('JTkeycheck',$key);

                if (self::_checkHome($email, $key, $product) === true) {
                    $session->set('JTlicensecheck', 1);
                    $key_session = $session->set('JTkeycheck', $key);
                    $email_session = $session->set('JTemailcheck', $email);
                    //$jt_tiempo = $session->set('JTtimeleft',$this->tiempo);

                    $valida = true;
                } else {
                    $session->set('JTlicensecheck', 0);
                    $valida = false;
                }
            } else {
                if ($session->get('JTlicensecheck') == 1) {
                    $valida = true;
                } else {
                    if (self::_checkHome($email, $key, $product) === true) {
                        $session->set('JTlicensecheck', 1);
                        $key_session = $session->set('JTkeycheck', $key);
                        $email_session = $session->set('JTemailcheck', $email);

                        $valida = true;
                    } else {
                        $valida = false;
                    }
                }
            }
        }

        return $valida;
    }

    private static function _checkHome($email, $key, $product = '1')
    {
        //REAL
        $url_check = 'https://users.jtotal.org/index.php?option=com_jtcontrol&tmpl=component&view=jtcheck&email=' . $email . '&key=' . $key . '&product=' . $product;

        $session = Factory::getSession();

        //CURL
        //var_dump(function_exists('curl_init'));
        if (function_exists('curl_init')) {
            $session->set('jtlicense_validation:', 'CURL');
            $checkHomeCurl = self::_checkHomeCurl($url_check);
            JtDebug::addDebug('CheckHome', 'home', 'Curl exists: ', microtime(true), 'table-info', basename(__FILE__, '.php'));
            return $checkHomeCurl;
        } else {
            //CURL_FALLBACK
            $session->set('jtlicense_validation:', 'fsockopen');
            JtDebug::addDebug('CheckHome', 'home', 'Curl FALLBACK', microtime(true), 'table-info', basename(__FILE__, '.php'));
            return self::checkHomeCurlFallback($url_check);
        }
    }

    public static function _checkHomeCurl($url_check)
    {

        $curl_response = curl_init($url_check);
        curl_setopt($curl_response, CURLOPT_HEADER, 0);
        curl_setopt($curl_response, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl_response, CURLOPT_NOSIGNAL, 1);
        curl_setopt($curl_response, CURLOPT_CONNECTTIMEOUT, 5);
        $response = curl_exec($curl_response);

        $session = Factory::getSession();
        //echo "</br>la respuesta es:".$response;
        //
        $response = json_decode($response);

        //response == success
        if (isset($response->success)) {
            if ($response->data == "OK") {
                $session->set('jtotallicensecheck', 1);
                self::$tiempo = $response->message->tiempo;

                JtDebug::addDebug('checkHomeCurl', 'thumbs-up', 'OK', microtime(true), 'table-info', basename(__FILE__, '.php'));
                //self::$error[] = 'Data OK';
                return true;
            } else {
                $session->set('jtotallicensecheck', 0);
                JtDebug::addDebug('checkHomeCurl', 'thumbs-down', 'no ok', microtime(true), 'table-info', basename(__FILE__, '.php'));
                self::$error[] = $response->message->error_msg;
                return false;
            }
        } else {
            self::$error[] = Text::_('JT_FW_LICENSE_ERROR_RECEIVING');
            return false;
        }
    }

    private static function checkHomeCurlFallback($url)
    {
        $session = Factory::getSession();
        $response = self::restHelper($url);
        $response = json_decode($response);

        //response == success
        if (isset($response->success)) {
            if ($response->data == "OK") {
                $session->set('jtotallicensecheck', 1);
                self::$tiempo = $response->message->tiempo;
                return true;
            } else {
                $session->set('jtotallicensecheck', 0);
                return false;
            }
        } else {
            self::$error[''] = 'Error receiving data';
            return false;
        }
    }

    private static function restHelper($url, $params = null, $verb = 'GET', $format = 'html')
    {
        $cparams = array(
            'http' => array(
                'method' => $verb,
                'ignore_errors' => true,
            ),
        );
        if ($params !== null) {
            $params = http_build_query($params);
            if ($verb == 'POST') {
                $cparams['http']['content'] = $params;
            } else {
                $url .= '?' . $params;
            }
        }

        $context = stream_context_create($cparams);
        $fp = fopen($url, 'rb', false, $context);
        if (!$fp) {
            $res = false;
        } else {
            $res = stream_get_contents($fp);
        }

        if ($res === false) {
            throw new InvalidArgumentException("failed to decode $res as json");
        }

        switch ($format) {
            case 'json':
                $r = json_decode($res);
                if ($r === null) {
                    throw new InvalidArgumentException("failed to decode $res as json");
                }
                return $r;
            case 'html':
                $r = $res;
                if ($r === null) {
                    throw new InvalidArgumentException("failed to decode $res as json");
                }
                return $r;
            case 'xml':
                $r = simplexml_load_string($res);
                if ($r === null) {
                    throw new InvalidArgumentException("failed to decode $res as json");
                }
                return $r;
        }
        return $res;
    }


    public static function headerLITE()
    {

        Factory::getApplication()->getLanguage()->load('plg_system_jtframework', JPATH_ADMINISTRATOR);

        $field_value = '<div class="alert alert-info">' . Text::_('JT_FW_EXTENSIONS_SOME_VALUES_LITE') . '</div>';

        return $field_value;
    }

    
    public static function mensajeLITE($custom_msg = '')
    {

        Factory::getApplication()->getLanguage()->load('plg_system_jtframework', JPATH_ADMINISTRATOR);

        $mensaje = '';

        $mensaje .= '<div class="well text-center">';

        if (count(self::$error) >= 1 && !empty(array_filter(self::$error))) {
            $mensaje .= '<div class="alert alert-warning">';
            $mensaje .= '</div>';
        }

        $mensaje .= '<div class="text-center">';

        $mensaje .= '</div>';
        $mensaje .= '<i class="fas fa-chess-pawn fa-3x"></i>';
        $mensaje .= '<br>';
        $mensaje .= '<h1>' . Text::_('JT_FW_LICENSE_LITE_H1') . '</h1>';
        $mensaje .= '<h3>' . Text::_('JT_FW_LICENSE_LITE_HEADER') . '</h3>';
        $mensaje .= '<h6>' . Text::_('JT_FW_LICENSE_LITE_HELPUS') . '</h6>';
        $mensaje .= '<i class="far fa-heart fa-2x fa-fw" aria-hidden="true"></i>';
        $mensaje .= '<i class="far fa-heart fa-2x fa-fw" aria-hidden="true"></i>';
        $mensaje .= '<i class="far fa-heart fa-2x fa-fw" aria-hidden="true"></i>';
        $mensaje .= '<br>';

        if ($custom_msg != '') {
            $mensaje .= '<br>';
            $mensaje .= '<p>' . $custom_msg . '</p>';
        }

        $mensaje .= '<div class="clearfix"></div>';
        $mensaje .= '<br>';

        $mensaje .= '<a class="btn btn-success bg-success" href="https://jtotal.org" target="_blank" rel="nofollow">
                       <i class="fas fa-2x fa-cart-arrow-down"></i>
                       <br>
                       <strong>' . Text::_('JT_FW_LICENSE_BUY') . '</strong><br>
                       <small>' . Text::_('JT_FW_LICENSE_BUY_AND') . '</small>
                   </a>';

        $mensaje .= '  <a class="btn btn-info bg-secondary" href="https://extensions.joomla.org/profile/profile/details/197422/" target="_blank" rel="nofollow">
                       <i class="fas fa-2x fa-feather"></i>
                       <br>
                       <strong>' . Text::_('JT_FW_LICENSE_REVIEW') . '</strong><br>
                       <small>' . Text::_('JT_FW_LICENSE_REVIEW_AND') . '</small>
                   </a>';

        $mensaje .= '  <a class="btn btn-default bg-primary text-light" href="https://users.jtotal.org/" target="_blank" rel="nofollow">
                           <i class="fas fa-2x fa-chess-queen"></i>
                           <br>
                           <strong>' . Text::_('JT_FW_LICENSE_I_ALREADY_HAVE') . '</strong><br>
                           <small>' . Text::_('JT_FW_LICENSE_GET_MY_KEY') . '</small>
                         </a>';
        $uri = Uri::getInstance();
        $troute = Route::_("index.php?option=com_plugins&task=plugin.edit&extension_id=" . self::getExtensionId() . '&return=' . base64_encode($uri));

        $mensaje .= '  <a class="btn btn-default bg-success text-light" href="' . $troute . '" rel="nofollow">
             <i class="fas fa-2x fa-unlock-alt"></i>
             <br>
             <strong>' . Text::_('JT_FW_LICENSE_ENTER_KEY') . '</strong><br>
             <small>' . Text::_('JT_FW_LICENSE_GET_PRO') . '</small>
           </a>';

        $mensaje .= '<br>';
        $mensaje .= '<br>';
        $mensaje .= '<br>';
        $mensaje .= '<img src="' . URI::root() . 'media/plg_system_jtframework/images/jtotal_soft.png" width="150"/>';
        $mensaje .= '</div>';

        //$mensaje.= ' <input type="hidden" class="jtotal_license_check" name="jtotal_license_check_js" value="0"/>';

        return $mensaje;
    }

    public static function mensajePRO($custom_msg = '')
    {

        Factory::getLanguage()->load('plg_system_jtframework', JPATH_ADMINISTRATOR);

        $mensaje = '';
        $mensaje .= '
            <div class="row jtotal_license_ok well" style="background: transparent url(../media/plg_system_jtframework/images/foco_total.png) no-repeat;     background-size: cover;
            background-position: left;">

           <div class="span9 col-sm-9 text-center p-2">';

        $mensaje .= '<i class="text-success fas fa-chess-queen fa-3x"></i>';
        $mensaje .= '<br><br>';
        $mensaje .= '<span class="text-success"><strong><i class="fas fa-unlock"></i> ' . Text::_('JT_FW_LICENSE_OK_ENJOY') . '</strong></span>';

        $mensaje .= '<br><br>';

        if ($custom_msg != '') {
            $mensaje .= '<br>';
            $mensaje .= '<p>' . $custom_msg . '</p>';
        }

        $mensaje .= '  <a class="btn btn-info bg-info" href="mailto:support@jtotal.org" target="_blank" rel="nofollow">
                       <i class="far fa-2x fa-life-ring"></i>
                       <br>
                       <strong>' . Text::_('JT_FW_LICENSE_SUPPORT') . '</strong><br>
                       <small>' . Text::_('JT_FW_LICENSE_SUPPORT_AND') . '</small>
                   </a>';

        $mensaje .= '  <a class="btn btn-info bg-info" href="https://users.jtotal.org/index.php/support" target="_blank" rel="nofollow">
                       <i class="far fa-2x fa-comments"></i>
                       <br>
                       <strong>' . Text::_('JT_FW_LICENSE_FORUM') . '</strong><br>
                       <small>' . Text::_('JT_FW_LICENSE_FORUM_AND') . '</small>
                   </a>';

        $mensaje .= '  <a class="btn btn-info bg-info" href="https://extensions.joomla.org/profile/profile/details/197422/" target="_blank" rel="nofollow">
                       <i class="fas fa-2x fa-feather"></i>
                       <br>
                       <strong>' . Text::_('JT_FW_LICENSE_REVIEW') . '</strong><br>
                       <small>' . Text::_('JT_FW_LICENSE_REVIEW_AND') . '</small>
                   </a>';

        $uri = Uri::getInstance();
        $troute = Route::_("index.php?option=com_plugins&task=plugin.edit&extension_id=" . self::getExtensionId() . '&return=' . base64_encode($uri));

        $mensaje .= '  <a class="btn btn-default bg-success text-light" href="' . $troute . '" rel="nofollow">
                   <i class="fas fa-2x fa-unlock-alt"></i>
                   <br>
                   <strong>' . Text::_('JT_FW_LICENSE_EDIT_KEY') . '</strong><br>

                 </a>';

        $mensaje .= '<br>';

        $mensaje .= '</div>';

        $mensaje .= '<div class="span3 col-sm-3 text-center d-flex align-items-center justify-content-center">
                   <img src="' . URI::root() . 'media/plg_system_jtframework/images/jtotal_portada.png" width="150"/>
                   </div>';
        $mensaje .= '</div>';

        return $mensaje;
    }

    private static function getExtensionId()
    {

        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select($db->quoteName('extension_id'))
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('folder') . ' = ' . $db->quote('system'))
            ->where($db->quoteName('element') . ' = ' . $db->quote('jtframework'));
        $db->setQuery($query);

        $result = (int) $db->loadResult();

        return $result;
    }

    public static function disableFormsv3($custom_msg = '')
    {

        //DISABLE BUTTONS
        Factory::getDocument()->addScriptDeclaration('

           jQuery(document).ready(function($) {
             jQuery(".fa-chess-queen").each(function(e){
               if($(this).parent().parent().hasClass("radio")){
                 $(this).parent().addClass("disabled").css("pointer-events","none");
               }
             });

           });
         ');
    }

    public static function disableFormsv4($custom_msg = '')
    {
        $wa = Factory::getDocument()->getWebAssetManager();

        //DISABLE Queen BUTTONS
        $wa->addInlineScript('

            document.addEventListener(\'DOMContentLoaded\', () => {
                const elements = document.querySelectorAll(\'.fa-chess-queen\');
              
                elements.forEach(element => {
                  const parent = element.parentElement.parentElement;
                    
                  //radio
                  if (parent.classList.contains(\'radio\')) {
                    element.parentElement.classList.add(\'disabled\');
                    element.parentElement.style.pointerEvents = \'none\';
                  }

                  //disable by LABEL
                  if (element.parentElement.tagName === (\'LABEL\')) {
                    const id = element.parentElement.attributes[\'for\'].value;
                    document.getElementById(id).disabled = true;
                  }

                });
              });

       ');
    }
}
