<?php

/**
 * @author          jtotal <support@jtotal.org>
 * @link            https://jtotal.org
 * @copyright       Copyright © 2020 JTOTAL All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

namespace Jtotal\Jtfw\Helper;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use ScssPhp\ScssPhp\Compiler;
use Jtotal\Jtfw\Helper\JtDebug;

defined('_JEXEC') or die('Restricted access');

/**
 *  JTscssphp Class
 */
class JtScssPhp
{

    public static function getScssphp()
    {
        return;

        JTdebug::addDebug('SCSSphp', 'check-circle', 'Loaded', microtime(TRUE), 'table-success', basename(__FILE__, '.php'));


        if (!class_exists('ScssPhp\ScssPhp\Compiler')) {
            if (is_file(JPATH_LIBRARIES . '/jtlibs/scssphp/autoload.php')) {
                require_once JPATH_LIBRARIES . '/jtlibs/scssphp/autoload.php';
            } else {
                $app = Factory::getApplication();
                $app->enqueueMessage(Text::_('JT_LIBS_NOT_FOUND'), 'error');
                return false;
            }
        }


        try {
            $scss = new Compiler();

            //deprecated
            //$scss->setFormatter('ScssPhp\ScssPhp\Formatter\Compressed');

            //$scss->setOutputStyle(\ScssPhp\ScssPhp\OutputStyle::EXPANDED);
            $scss->setOutputStyle(\ScssPhp\ScssPhp\OutputStyle::COMPRESSED);
        } catch (\Exception $e) {
            $app = Factory::getApplication();
            $app->enqueueMessage(Text::_('JT_FW_SCSS_ERROR') . '</br>' . $e, 'error');
            return false;
        }

        return $scss;
    }

    /**
     * Loads scssPhp library
     *
     * @return object
     */
    public static function getScssphp2()
    {
        
        JtDebug::addDebug('SCSSphp', 'check-circle', 'Loaded', microtime(true), 'table-success', basename(__FILE__, '.php'));

        if (!class_exists('ScssPhp\ScssPhp\Compiler')) {
            if (is_file(JPATH_LIBRARIES . '/jtlibs/vendor/autoload.php')) {
                require_once JPATH_LIBRARIES . '/jtlibs/vendor/autoload.php';
            } else {
                $app = Factory::getApplication();
                $app->enqueueMessage(Text::_('JT_LIBS_NOT_FOUND'), 'error');
                return false;
            }
        }

        try {
            $scss = new Compiler();
            $scss->setOutputStyle(\ScssPhp\ScssPhp\OutputStyle::COMPRESSED);
        } catch (\Exception $e) {
            $app = Factory::getApplication();
            $app->enqueueMessage(Text::_('JT_FW_SCSS_ERROR') . '</br>' . $e, 'error');
            return false;
        }

        return $scss;
    }
}
