<?php
/**
 * @package     Jtotal.Plugin
 * @subpackage  Content.jtattach
 * @copyright   Copyright (C) 2025 Jtotal. All rights reserved.
 * @license     GNU General Public License version 2 or later; see https://jtotal.org/LICENSE.txt
*/

namespace Jtotal\Plugin\Content\Jtattach\Fields;

// Cambiado de JPATH_PLATFORM a _JEXEC
defined('_JEXEC') or die;

use Exception;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Jtotal\Jtfw\Helper\JtLicense;

class JtCheckField extends FormField
{
    protected $type = 'JtCheck';

    // Añadido tipo de retorno string
    protected function getLabel(): string
    {
        $mode = $this->element['mode'];
        if ($mode == 'dashboard') {
            return ''; // Devolver string vacío en lugar de null
        }
        
        return ''; // Valor por defecto
    }

    // Añadido tipo de retorno string
    protected function getInput(): string
    {
        // Load the system plugin language
        $lang = Factory::getLanguage();
        $lang->load('plg_system_jtframework', JPATH_ADMINISTRATOR);
        $lang->load('plg_system_jtframework', JPATH_PLUGINS . '/system/jtframework');

        $field_set = $this->form->getFieldset();
        $params = $this->form->getValue('params');

        $valida = JtLicense::_checkLicense();

        $field_value = '';

        if ($valida) {
            $field_value .= $this->pro();
        }

        if (!$valida) {
            $field_value .= $this->lite();
        }

        return $field_value;
    }

    // Añadido tipo de retorno string
    private function lite(): string
    {
        JtLicense::disableFormsv4();

        $module_id = $this->form->getValue('id');
        $params = $this->form->getValue('params');

        if ($params !== null) {
            $params->debug_mode = 0;
            $params->og_multi_img = 0;
            $params->og_add_dom_img = 0;
            $params->og_skip_intro_img = 0;
            $params->opengraph_default_image_opt = 0;
            $params->opengraph_metadescription = 0;
            $params->opengraph_default_data = 0;
            $params->s2s_og_twitter = 0;
        } else {
            return $this->mensajeLITE();
        }

        $params->jtotal_license_check = 0;

        // Consulta
        $reparams = $this->form->getValue('params');
        $encode_params = json_encode($reparams);

        $plugin_element = 'social2sog';
        $plugin_folder = 'system';
        
        try {
            // ✅ Cambio principal: usar getContainer()->get('DatabaseDriver') en lugar de getDBO()
            $db = Factory::getContainer()->get('DatabaseDriver');
            $query = $db->getQuery(true);
            
            // Actualizar en #__extensions para plugins
            $query->update($db->quoteName('#__extensions'))
                ->set($db->quoteName('params') . ' = ' . $db->quote($encode_params))
                ->where($db->quoteName('type') . ' = ' . $db->quote('plugin'))
                ->where($db->quoteName('folder') . ' = ' . $db->quote($plugin_folder))
                ->where($db->quoteName('element') . ' = ' . $db->quote($plugin_element));

            $db->setQuery($query);
            $result = $db->execute();

            if ($result) {
                Factory::getApplication()->enqueueMessage('Parámetros del plugin actualizados correctamente.', 'success');
            }
        } catch (Exception $e) {
            Factory::getApplication()->enqueueMessage('Error al actualizar parámetros del plugin: ' . $e->getMessage(), 'error');
        }

        return $this->mensajeLITE();
    }

    // Añadido tipo de retorno string
    private function pro(): string
    {
        $params = $this->form->getValue('params');

        $field_value = '<div class="row">';
        $field_value .= '<div class="col-md-10">';
        $field_value .= '<div class="text-success">' . Text::_('JT_FW_EXTENSIONS_ENJOY_PRO') . '</div>';
        $field_value .= '</div>';
        $field_value .= '</div>';

        return $field_value;
    }

    // Añadido tipo de retorno string
    private function mensajeLITE(): string
    {
        $field_value = '<div class="row">';
        $field_value .= '<div class="col-md-10">';
        $field_value .= '<div class="alert alert-info">' . Text::_('JT_FW_EXTENSIONS_SOME_VALUES_LITE') . '</div>';
        $field_value .= '</div>';
        $field_value .= '</div>';

        return $field_value;
    }
}
