<?php

namespace Jtotal\Plugin\System\Social2sOg\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Registry\Registry;

/**
 * Helper class for debug output in Social2sOg System plugin.
 */
class S2sDebugOg
{
    protected Registry $params;
    private $app;
    private array $s2sOgDebug = [];
    private float $startMicro;

    public function __construct(Registry $params)
    {
        $this->params = $params;
        $this->app = Factory::getApplication();
        $this->startMicro = microtime(true);
    }

    /**
     * Add debug entry
     */
    public function add(
        string $label,
        string $message = '',
        string $style = 'default',
        string $icon = 'debug',
        bool $time = true
    ): void {
        if (!$this->isEnabled()) {
            return;
        }

        $debugHtml = '<td class="text-end"><i class="fa fa-' . htmlspecialchars($icon, ENT_QUOTES, 'UTF-8') . '" aria-hidden="true"></i> <strong>' . htmlspecialchars($label, ENT_QUOTES, 'UTF-8') . '</strong></td>';
        $debugHtml .= '<td><span class="text-' . htmlspecialchars($style, ENT_QUOTES, 'UTF-8') . '">' . $message . '</span></td>';
        $debugHtml .= '<td class="text-center">';
        
        if ($time) {
            $currentTime = microtime(true);
            $totalTime = ($currentTime - $this->startMicro) * 1000;
            $debugHtml .= '<small>' . number_format($totalTime, 2) . ' ms</small>';
        }
        
        $debugHtml .= '</td>';
        
        $this->s2sOgDebug[] = $debugHtml;
    }

    /**
     * Display debug table
     */
    public function show(): void
    {

       
        if (!$this->params->get('s2s_og_debug', 0)) {
            return;
        }

        if (empty($this->s2sOgDebug)) {
            return;
        }

        $totalTime = (microtime(true) - $this->startMicro) * 1000;

        $html = '
        <div class="s2s-og-debug-output" style="position: fixed; bottom: 20px; left: 20px; right: 20px; max-width: 100%; max-height: 80vh; overflow-y: auto; margin: 0; padding: 0; background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 5px; box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15); z-index: 9999;">
            <div class="d-flex justify-content-between align-items-center" style="padding: 15px 20px; border-bottom: 1px solid #dee2e6;">
            <h3 style="color: #0d6efd; margin: 0;">
            <i class="fa fa-share-alt"></i> Social2s OpenGraph Debug
            <small style="color: #6c757d; margin-left: 10px;">' . number_format($totalTime, 2) . ' ms total</small>
            </h3>
            <button type="button" class="btn-close" aria-label="Close" onclick="this.closest(\'.s2s-og-debug-output\').remove();" style="cursor: pointer;"></button>
            </div>
            <div style="padding: 20px;">
            <div class="table-responsive">
            <table class="table table-striped table-sm table-bordered">
            <thead>
                <tr class="table-info">
                <th class="text-end" style="width: 20%;">Label</th>
                <th>Message</th>
                <th class="text-center" style="width: 15%;"><i class="fa fa-clock-o"></i> Time</th>
                </tr>
            </thead>
            <tbody>';

        foreach ($this->s2sOgDebug as $row) {
            $html .= '<tr>' . $row . '</tr>';
        }

        $html .= '
                    </tbody>
                </table>
            </div>
            <div style="margin-top: 10px; font-size: 12px; color: #6c757d;">
                Total debug entries: ' . count($this->s2sOgDebug) . '
            </div>
            <div> <small>Generated by Social2s OpenGraph Plugin</small> | <small>You can disable this debug output in the Social2s plugin settings.</small> </div>
        </div>';

        echo $html;
    }

    /**
     * Check if debug is enabled
     */
    public function isEnabled(): bool
    {
   
        //social2s content plugin params override
        $contentPlugin = \Joomla\CMS\Plugin\PluginHelper::getPlugin('content', 'social2s');
        if ($contentPlugin) {
            $contentParams = new Registry($contentPlugin->params);
            if ($contentParams->get('s2s_og_debug')) {
                $this->params->set('s2s_og_debug', $contentParams->get('s2s_og_debug'));
            }
        }

        return (bool) $this->params->get('s2s_og_debug', 0);
    }
}
