<?php
/**
 * @package     Social2s.Plugin
 * @subpackage  Content.Social2s
 * @copyright   Copyright (C) 2025 Jtotal. All rights reserved.
 * @license     GNU General Public License version 2 or later; see https://jtotal.org/LICENSE.txt
*/

namespace Jtotal\Plugin\Content\Social2s\Fields;

use Exception;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Jtotal\Jtfw\Helper\JtLicense;

// Cambiado de JPATH_PLATFORM a _JEXEC
defined('_JEXEC') or die;

$jtfwAutoload = JPATH_PLUGINS . '/system/jtframework/autoload.php';
if (is_file($jtfwAutoload)) {
    require_once $jtfwAutoload;
} else {
    Factory::getApplication()->enqueueMessage(Text::_('JT_FW_NOT_FOUND'), 'error');
    return;
}

class JtCheckField extends FormField
{
    protected $type = 'JtCheck';

    // Añadido tipo de retorno string
    protected function getLabel(): string
    {
        $mode = $this->element['mode'];
        if ($mode == 'dashboard') {
            return '';
        }
        return '';
    }

    // Añadido tipo de retorno string
    protected function getInput(): string
    {
        $field_set = $this->form->getFieldset();
        $params = $this->form->getValue('params');

        $valida = false;
        $valida = JtLicense::_checkLicense();

        $field_value = '';

        if ($valida) {
            $field_value .= $this->pro();
        }

        if (!$valida) {
            $field_value .= $this->lite();
        }

        return $field_value;
    }

    // Añadido tipo de retorno string
    private function lite(): string
    {
        JtLicense::disableFormsv4();

        $module_id = $this->form->getValue('id');
        $params = $this->form->getValue('params');

        if ($params !== null) {
            //v4
            $params->s2s_text_to_share = '0';
            $params->og_multi_img = '0';
            $params->og_add_dom_img = '0';
            $params->og_skip_intro_img = '0';

            //v3
            $params->social2s_base = '0';
            $params->s2s_virtuemart = '0';
            $params->s2s_takefromarticle = '1';
            $params->twitter_follow = '0';
            $params->twitter_cards = '0';
            $params->opengraph_default_image_opt = '0';
            $params->s2s_jevents = '0';
            $params->s2s_og_debug = '0';
            $params->og_skip_min_img = '0';
            $params->twitter_fast_as_light = '0';
            $params->s2s_art_balloon_pos = '0';
            $params->opengraph_metadescription = '0';
            $params->twitter_cards_summary = '0';
            $params->s2s_display_universal = '0';

            if (isset($params->mas_on)) {
                if ($params->mas_on == 2) {
                    $params->mas_on = '0';
                }
            }
            $params->mas_style = 'plus-square';

            if (isset($params->s2s_art_fill)) {
                if ($params->s2s_art_fill == 2) {
                    $params->s2s_art_fill = 0;
                }
            }
        } else {
            return $this->mensajeLITE();
        }

        // Consulta - el uso de Factory::getContainer()->get('DatabaseDriver') es correcto
        $reparams = $this->form->getValue('params');
        $encode_params = json_encode($reparams);

        $db = Factory::getContainer()->get('DatabaseDriver');
        $query = $db->getQuery(true);
        
        // Build the query
        $query->update($db->quoteName('#__extensions'));
        $query->set($db->quoteName('params') . ' = ' . $db->quote((string) $encode_params));
        $query->where($db->quoteName('element') . ' = ' . $db->quote("social2s"));

        // Execute the query
        $db->setQuery($query);

        try {
            $db->setQuery($query)->execute();
        } catch (Exception $e) {
            echo Text::sprintf('JLIB_DATABASE_ERROR_FUNCTION_FAILED', $e->getCode(), $e->getMessage()) . '<br>';
            return $this->mensajeLITE(); // Asegurar que siempre devuelve string
        }

        return $this->mensajeLITE();
    }

    // Añadido tipo de retorno string
    private function pro(): string
    {
        $version = self::getVersion();
        $field_value = '<div class="s2s_version"><span class="badge badge-success bg-success">PRO version: ' . $version . '</span></div>';

        return $field_value;
    }

    // Añadido tipo de retorno string
    private function mensajeLITE(): string
    {
        $version = self::getVersion();

        $field_value = '<div class="s2s_version"><span class="badge badge-success bg-primary">FREE version: ' . $version . '</span></div>';
        $field_value .= JtLicense::headerLITE();

        return $field_value;
    }

    // Añadido tipo de retorno string|null
    private static function getVersion(): ?string
    {
        $db = Factory::getContainer()->get('DatabaseDriver');
        $query = $db->getQuery(true);
        $query
            ->select(array('*'))
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('type') . ' = ' . $db->quote('plugin'))
            ->where($db->quoteName('element') . ' = ' . $db->quote('social2s'))
            ->where($db->quoteName('folder') . ' = ' . $db->quote('content'));
        $db->setQuery($query);
        $result = $db->loadObject();
        
        if ($result) {
            $manifest_cache = json_decode($result->manifest_cache);
            if (isset($manifest_cache->version)) {
                return $manifest_cache->version;
            }
        }
        
        return null; // Devolver null explícitamente
    }
}
