<?php

/**
 * @package     Social2s.Plugin
 * @subpackage  Content.Social2s
 * @copyright   Copyright (C) 2025 Jtotal. All rights reserved.
 * @license     GNU General Public License version 2 or later; see https://jtotal.org/LICENSE.txt
*/

namespace Jtotal\Plugin\Content\Social2s\Fields;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;

class S2sBackendField extends FormField
{
    protected $type = 'S2sBackend';

    protected function getLabel(): string
    {
        // Sin etiqueta en la vista de parámetros
        return '';
    }

    protected function getInput(): string
    {
        // Leer el parámetro desde el grupo 'params'
        $social2s_minify_debug = (int) $this->form->getValue('social2s_minify_debug', 'params');

        // Web Asset Manager
        $wa = Factory::getApplication()->getDocument()->getWebAssetManager();

        // Registrar el joomla.asset.json del plugin (obligatorio en plugins)
        $wa->getRegistry()->addRegistryFile('media/plg_content_social2s/joomla.asset.json');

        // Marcar como usados los assets definidos en el JSON
        $wa->useStyle('plg_content_social2s.backend');
        $wa->useScript('plg_content_social2s.backend');

        // Devolver algún HTML (aunque sea vacío) para cumplir la firma
        return '';
    }
}
