<?php
/**
 * @package     Social2s.Plugin
 * @subpackage  Content.Social2s
 * @copyright   Copyright (C) 2025 Jtotal. All rights reserved.
 * @license     GNU General Public License version 2 or later; see https://jtotal.org/LICENSE.txt
*/

namespace Jtotal\Plugin\Content\Social2s\Fields;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;

// Cambiado de JPATH_PLATFORM a _JEXEC
defined('_JEXEC') or die;

class S2sJeventsCheckField extends FormField
{
    protected $type = 'S2sJeventsCheck';

    // Añadido método getLabel con tipo de retorno string
    protected function getLabel(): string
    {
        return '';
    }

    // Añadido tipo de retorno string
    protected function getInput(): string
    {
        $db = Factory::getContainer()->get('DatabaseDriver');
        $query = $db->getQuery(true);

        $query
            ->select($db->quoteName(array('element', 'enabled')))
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('element') . ' = ' . $db->quote('jevsocial2s'));

        $db->setQuery($query);
        $results = $db->loadObjectList();

        if (count($results) >= 1) {
            //jevents exists
            if ($results[0]->enabled == 1) {
                //exists and enabled
                $field_value = '<div class="alert alert-success">' . Text::_('S2S_JEVENTS_PRESENT_ACTIVE') . '</div>';
            } else {
                $field_value = '<div class="alert alert-warning">' . Text::_('S2S_JEVENTS_PRESENT_NOT_ACTIVE') . '</div>';
            }
        } else {
            $field_value = '<div class="alert alert-danger">' . Text::_('S2S_JEVENTS_NOTE') . '</div>';
        }
        
        return $field_value;
    }
}
