<?php
/**
 * @package     Social2s.Plugin
 * @subpackage  Content.Social2s
 * @copyright   Copyright (C) 2025 Jtotal. All rights reserved.
 * @license     GNU General Public License version 2 or later; see https://jtotal.org/LICENSE.txt
*/
namespace Jtotal\Plugin\Content\Social2s\Fields;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Version;

// Cambiado de JPATH_PLATFORM a _JEXEC
defined('_JEXEC') or die;

class S2sLegendField extends FormField
{
    protected $type = 'S2sLegend';

    // Añadido método getLabel con tipo de retorno string
    protected function getLabel(): string
    {
        return '';
    }

    // Añadido tipo de retorno string
    protected function getInput(): string
    {
        $field_set = $this->form->getFieldset();

        $field_value = '<div class="alert alert-info">
            <p><span class="fa fa-2x fa-exclamation-triangle"></span> ' . Text::_('SOCIAL2S_FIELD_LEGEND_WARNING') . '</p>
            <p><span class="far fa-2x fa fa-chess-queen"></span> ' . Text::_('SOCIAL2S_FIELD_LEGEND_PRO') . '</p>
            <p><span class="far fa-2x fa-thumbs-up"></span> ' . Text::_('SOCIAL2S_FIELD_LEGEND_RECOMMENDED') . '</p>
        </div>';

        return $field_value;
    }
}
