<?php
/**
 * @package     Social2s.Plugin
 * @subpackage  Content.Social2s
 * @copyright   Copyright (C) 2025 Jtotal. All rights reserved.
 * @license     GNU General Public License version 2 or later; see https://jtotal.org/LICENSE.txt
*/

namespace Jtotal\Plugin\Content\Social2s\Fields;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;

// Cambiado de JPATH_PLATFORM a _JEXEC
defined('_JEXEC') or die;

class S2sOgCheckField extends FormField
{
    protected $type = 'S2sOgCheck';

    // Añadido método getLabel con tipo de retorno string
    protected function getLabel(): string
    {
        return '';
    }

    // Añadido tipo de retorno string
    protected function getInput(): string
    {
        $html = '';
        
        // Obtener servicios del contenedor
        $db = Factory::getContainer()->get('DatabaseDriver');
        
        // Agregar el token de la sesión para seguridad
        $token = Session::getFormToken();
        
        // Comprueba si el plugin está instalado, aunque esté deshabilitado
        $query = $db->getQuery(true)
            ->select($db->quoteName(['extension_id', 'enabled', 'params']))
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('type') . ' = ' . $db->quote('plugin'))
            ->where($db->quoteName('folder') . ' = ' . $db->quote('system'))
            ->where($db->quoteName('element') . ' = ' . $db->quote('social2sog'));
        
        $db->setQuery($query);
        $plugin = $db->loadObject();
        
        if (!$plugin) {
            // Plugin no existe
            $html = '<div class="alert alert-info">'
                . Text::_('PLG_SOCIAL2S_FIELD_SOCIAL2SOG_NOT_INSTALLED')
                . '</div>';
        } elseif (!$plugin->enabled) {
            // Existe pero no está habilitado → Enlace para habilitar en modal
            $modalId = 'social2sogModal';
            $urlEdit = 'index.php?option=com_plugins&amp;task=plugin.edit&amp;extension_id=' . $plugin->extension_id . '&amp;' . Session::getFormToken() . '=1';

            $html = '<div class="alert alert-warning">'
                . Text::_('PLG_SOCIAL2S_FIELD_SOCIAL2SOG_DISABLED')
                . ' <button type="button" class="btn btn-sm btn-outline-primary ms-2" data-bs-toggle="modal" data-bs-target="#ModalEdit' . $modalId . '">'
                . Text::_('PLG_SOCIAL2S_FIELD_SOCIAL2SOG_ACTIVATE_PLUGIN')
                . '</button>'
                . '</div>';
                
            // Renderizar el modal usando el helper estándar de Joomla
            $modalHtml = HTMLHelper::_(
                'bootstrap.renderModal',
                'ModalEdit' . $modalId,
                array(
                    'title'       => Text::_('PLG_SOCIAL2S_FIELD_SOCIAL2SOG_MODAL_TITLE'),
                    'backdrop'    => 'static',
                    'keyboard'    => false,
                    'closeButton' => true,
                    'url'         => $urlEdit,
                    'height'      => '400px',
                    'width'       => '800px',
                    'bodyHeight'  => 70,
                    'modalWidth'  => 80,
                    'footer'      => '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">'
                                    . Text::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>'
                )
            );
            
            $html .= $modalHtml ?? ''; // Asegurar que no sea null

       
            
            // Script para recargar la página cuando se cierra el modal
            $html .= '<script>
                document.addEventListener("DOMContentLoaded", function() {
                    var modal = document.getElementById("ModalEdit' . $modalId . '");
                    if (modal) {
                        modal.addEventListener("hidden.bs.modal", function() {
                            window.location.reload();
                        });
                    }
                });
            </script>';
        } else {
            // Plugin existe y está habilitado, verificar parámetro "opengraph"
            $params = json_decode($plugin->params);
            $opengraphEnabled = isset($params->opengraph) && $params->opengraph;

            $modalId = 'social2sogConfigModal';
            $urlEdit = Route::_('index.php?option=com_plugins&task=plugin.edit&extension_id=' . $plugin->extension_id . '&' . $token . '=1');
            
            if ($opengraphEnabled) {
                $html = '<div class="alert alert-success d-flex align-items-start">'
                    . '<span>' . Text::_('PLG_SOCIAL2S_FIELD_SOCIAL2SOG_INSTALLED_ACTIVE_OG_ENABLED') . '</span>'
                    . '<button type="button" class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#ModalEdit' . $modalId . '">'
                    . '<i class="fas fa-cog"></i> ' . Text::_('PLG_SOCIAL2S_FIELD_SOCIAL2SOG_EDIT_CONFIG')
                    . '</button>'
                    . '</div>';
            } else {
                $html = '<div class="alert alert-info d-flex justify-content-between align-items-center">'
                    . '<span>' . Text::_('PLG_SOCIAL2S_FIELD_SOCIAL2SOG_INSTALLED_ACTIVE_OG_DISABLED') . '</span>'
                    . '<button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#ModalEdit' . $modalId . '">'
                    . Text::_('PLG_SOCIAL2S_FIELD_SOCIAL2SOG_CONFIGURE_PLUGIN')
                    . '</button>'
                    . '</div>';
            }
                
            // Renderizar el modal usando el helper estándar de Joomla (compartido para ambos casos)
            $modalHtml = HTMLHelper::_(
                'bootstrap.renderModal',
                'ModalEdit' . $modalId,
                array(
                    'title'       => Text::_('PLG_SOCIAL2S_FIELD_SOCIAL2SOG_MODAL_CONFIG_TITLE'),
                    'backdrop'    => 'static',
                    'keyboard'    => false,
                    'closeButton' => true,
                    'url'         => $urlEdit,
                    'height'      => '400px',
                    'width'       => '800px',
                    'bodyHeight'  => 70,
                    'modalWidth'  => 80,
                    'footer'      => '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">'
                                    . Text::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>'
                )
            );
            
            $html .= $modalHtml ?? ''; // Asegurar que no sea null
            
            // Script para recargar la página cuando se cierre el modal
            $html .= '<script>
                document.addEventListener("DOMContentLoaded", function() {
                    var modal = document.getElementById("ModalEdit' . $modalId . '");
                    if (modal) {
                        modal.addEventListener("hidden.bs.modal", function() {
                            window.location.reload();
                        });
                    }
                });
            </script>';
        }
        
        return $html;
    }

    // Añadido tipo de retorno para el método auxiliar
    protected function getApplication(): object
    {
        return Factory::getApplication();
    }
}
