<?php
/**
 * @package     Social2s.Plugin
 * @subpackage  Content.Social2s
 * @copyright   Copyright (C) 2025 Jtotal. All rights reserved.
 * @license     GNU General Public License version 2 or later; see https://jtotal.org/LICENSE.txt
*/

namespace Jtotal\Plugin\Content\Social2s\Fields;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Version;

// Cambiado de JPATH_PLATFORM a _JEXEC
defined('_JEXEC') or die;

class S2sOrderField extends FormField
{
    protected $type = 'S2sOrder';

    // Añadido método getLabel con tipo de retorno string
    protected function getLabel(): string
    {
        return '';
    }

    // Añadido tipo de retorno string
    protected function getInput(): string
    {
        $orden = strtolower($this->value);
        $field_set = $this->form->getFieldset();
        $field_value = '';

        $jversion = new Version();
        $jversion = substr($jversion->getShortVersion(), 0, 1);

        //number of characters to prevent errors
        if (strlen($orden) != 31) {
            $orden = '0,1,2,3,4,5,6,7,8,9,10,11,12,13';
        }
        $order_array = explode(',', $orden);
        $new_order = array();

        $field_value .= '<table id="s2sTableOrder" onmouseup="s2sUpdateOrder()">';
        $field_value .= '<tbody style="margin-left:0;" class="s2s_order btn-group js-draggable" data-url="">';

        foreach ($order_array as $key => $value) {
            if ($value == '0') {
                $field_value .= '<tr><td><li data-s2s="0" class="btn btn-small"><i class="fab fa-2x fa-twitter"></i></li></td></tr>';
            } elseif ($value == '1') {
                $field_value .= '<tr><td><li data-s2s="1" class="btn btn-small"><i class="fab fa-2x fa-facebook"></i></td></tr>';
            } elseif ($value == '2') {
                $field_value .= '<tr><td><li data-s2s="2" class="btn btn-small"><i class="fab fa-2x fa-pinterest"></i></td></tr>';
            } elseif ($value == '3') {
                $field_value .= '<tr><td><li data-s2s="3" class="btn btn-small"><i class="fab fa-2x fa-linkedin"></i></td></tr>';
            } elseif ($value == '4') {
                $field_value .= '<tr><td><li data-s2s="4" class="btn btn-small disabled"><i class="fab fa-google-plus"></i><i class="fas fa-skull"></i></td></tr>';
            } elseif ($value == '5') {
                $field_value .= '<tr><td><li data-s2s="5" class="btn btn-small"><i class="fab fa-2x fa-whatsapp"></i></td></tr>';
            } elseif ($value == '6') {
                $field_value .= '<tr><td><li data-s2s="6" class="btn btn-small"><i class="fab fa-2x fa-telegram"></i></td></tr>';
            } elseif ($value == '7') {
                $field_value .= '<tr><td><li data-s2s="7" class="btn btn-small"><i class="fab fa-2x fa-flipboard"></i></td></tr>';
            } elseif ($value == '8') {
                $field_value .= '<tr><td><li data-s2s="8" class="btn btn-small"><i class="fab fa-2x fa-delicious"></i></td></tr>';
            } elseif ($value == '9') {
                $field_value .= '<tr><td><li data-s2s="9" class="btn btn-small"><i class="fab fa-2x fa-tumblr"></i></td></tr>';
            } elseif ($value == '10') {
                $field_value .= '<tr><td><li data-s2s="10" class="btn btn-small"><i class="fab fa-2x fa-vk"></i></td></tr>';
            } elseif ($value == '11') {
                $field_value .= '<tr><td><li data-s2s="11" class="btn btn-small"><i class="fas fa-2x fa-envelope"></i></td></tr>';
            } elseif ($value == '12') {
                $field_value .= '<tr><td><li data-s2s="12" class="btn btn-small"><i class="fab fa-2x fa-reddit"></i></td></tr>';
            } elseif ($value == '13') {
                $field_value .= '<tr><td><li data-s2s="13" class="btn btn-small"><i class="fas fa-2x fa-' . $field_set['jform_params_mas_style']->value . '"></i></li></td></tr>';
            }
            $new_order[] = $value;
        }

        $field_value .= '</tbody>';
        $field_value .= '</table>';

        $app = Factory::getApplication();
        
        $document = Factory::getApplication()->getDocument();
        $wa = $document->getWebAssetManager();

        $wa->addInlineScript('
            function s2sUpdateOrder(){
                let lis = document.getElementById(\'s2sTableOrder\').getElementsByTagName(\'li\');
                let newOrder = [];
                //resto 1 por el extra LI de dragula
                for(let i = 0; i < (lis.length-1); i++){
                    //lis[i].setAttribute(\'data-s2s\', i);
                    newOrder.push(lis[i].getAttribute(\'data-s2s\'));
                }
                document.getElementById(\'inputS2sOrder\').value = newOrder.toString();
            }
        ');

        HTMLHelper::_('draggablelist.draggable');

        $field_value .= '</br>';
        $field_value .= '<input id="inputS2sOrder" class="input_s2s_orden" type="hidden" name="' . $this->name . '" value="' . $orden . '" />';

        return $field_value;
    }
}
