<?php
/**
 * @package     Social2s.Plugin
 * @subpackage  Content.Social2s
 * @copyright   Copyright (C) 2025 Jtotal. All rights reserved.
 * @license     GNU General Public License version 2 or later; see https://jtotal.org/LICENSE.txt
*/

namespace Jtotal\Plugin\Content\Social2s\Fields;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;

// Cambiado de JPATH_PLATFORM a _JEXEC
defined('_JEXEC') or die;

class S2sUniversalCheckField extends FormField
{
    protected $type = 'S2sUniversalCheck';

    // Añadido método getLabel con tipo de retorno string
    protected function getLabel(): string
    {
        return '';
    }

    // Añadido tipo de retorno string
    protected function getInput(): string
    {
        $db = Factory::getContainer()->get('DatabaseDriver');
        $query = $db->getQuery(true);

        $query
            ->select($db->quoteName(array('element', 'enabled')))
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('element') . ' = ' . $db->quote('mod_s2suniversal'));

        $db->setQuery($query);
        $results = $db->loadObjectList();

        if (count($results) >= 1) {
            $field_value = '<div class="alert alert-success">' . Text::_('S2S_UNIVERSAL_PRESENT') . '</div>';
            $field_value .= '<div class="alert alert-success"><a href="index.php?option=com_modules&view=modules&client_id=0&filter_module=mod_s2suniversal">Go to Modules</a></div>';
        } else {
            // Cambiado alert-error por alert-danger (clase Bootstrap estándar)
            $field_value = '<div class="alert alert-danger">' . Text::_('S2S_UNIVERSAL_NOT_INSTALLED') . '</div>';
        }
        
        return $field_value;
    }
}
