<?php
/**
 * @package     Social2s.Plugin
 * @subpackage  Content.Social2s
 * @copyright   Copyright (C) 2025 Jtotal. All rights reserved.
 * @license     GNU General Public License version 2 or later; see https://jtotal.org/LICENSE.txt
*/

namespace Jtotal\Plugin\Content\Social2s\Fields;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Registry\Registry;

// Cambiado de JPATH_PLATFORM a _JEXEC
defined('_JEXEC') or die;

class S2sbs1stField extends FormField
{
    protected $type = 'S2sbs1st';

    // Añadido tipo de retorno string
    protected function getLabel(): string
    {
        return '';
    }

    // Añadido tipo de retorno string
    protected function getInput(): string
    {
        $field_set = $this->form->getFieldset();

        $params = new Registry($this->form->getValue('params'));
        $s2s_active_accordeons = $params->get('s2s_active_accordeons', '');

        $id = ($this->element['id'] === null) ? '' : strtolower($this->element['id']);
        $mode = ($this->element['mode'] === null) ? '' : strtolower($this->element['mode']);

        $initial = ($this->element['initial'] === null) ? '' : strtolower($this->element['initial']);
        $label = ($this->element['label'] === null) ? '' : strtolower($this->element['label']);
        $slide = ($this->element['slide'] === null) ? '' : strtolower($this->element['slide']);
        $acordeon = ($this->element['acordeon'] === null) ? '' : strtolower($this->element['acordeon']);

        $active_default = ($this->element['active'] === null) ? '' : strtolower($this->element['active']);

        if ($initial == 'true') {
            if (is_array(json_decode($s2s_active_accordeons))) {
                $active = (in_array($active_default, json_decode($s2s_active_accordeons))) ? $active_default : '';
            } else {
                $active = '';
            }

            $accStart = HTMLHelper::_('bootstrap.startAccordion', $acordeon, array('active' => $active));
            return $accStart ?? ''; // Asegurar que devuelve string
        } elseif ($initial == 'slide') {
            $slider = HTMLHelper::_('bootstrap.addSlide', $acordeon, Text::_($label), $slide);
            return $slider ?? ''; // Asegurar que devuelve string
        } elseif ($initial == 'end') {
            $end = HTMLHelper::_('bootstrap.endSlide');
            return $end ?? ''; // Asegurar que devuelve string
        } elseif ($initial == 'superend') {
            $superend = HTMLHelper::_('bootstrap.endAccordion');
            return $superend ?? ''; // Asegurar que devuelve string
        }
        
        // Devolver string vacío si no se cumple ninguna condición
        return '';
    }
}
