<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  Content.social2s
 * @copyright   Copyright (C) 2005 - 2023 jtotal.org All rights reserved. // Updated year maybe?
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper; // Useful for potential future use (e.g., escaping)

/**
 * Social2s Plugin Default Layout
 *
 * Layout variables passed from S2sTmpl::init() via HTMLHelper::_('renderlayout', ...)
 * -----------------------------------------------------------------------------------
 * @var   \Jtotal\Plugin\Content\Social2s\Extension\Social2s $plugin        The main plugin instance. Access params via $plugin->getParams().
 * @var   object                                             $articleData   Object containing prepared data (title, link, description, images, etc.).
 * @var   object                                             $styles        Object containing calculated style properties (align, size, etc.).
 * @var   object                                             $supraClasses  Object containing the calculated CSS class string ('classes' property).
 * @var   string                                             $buttonHtml    The pre-rendered HTML string for the social buttons.
 */

// Get parameters instance for convenience
$params = $plugin->getParams();

// --- Start Output ---
?>
<div class="s2s_supra_contenedor <?php echo htmlspecialchars($supraClasses->classes ?? '', ENT_QUOTES, 'UTF-8'); ?>"
     data-s2s-url="<?php echo htmlspecialchars($articleData->full_link ?? '', ENT_QUOTES, 'UTF-8'); ?>"
     data-s2s-title="<?php echo htmlspecialchars($articleData->title ?? '', ENT_QUOTES, 'UTF-8'); ?>"
     >

    <?php // Optional: Hidden input kept for compatibility if JS still relies on it, but data attributes are better ?>
    <input name="social2s_url" type="hidden" class="social2s_url" value="<?php echo htmlspecialchars($articleData->full_link ?? '', ENT_QUOTES, 'UTF-8'); ?>" />

    <?php
    // --- Share Text ---
    $showShareText = $params->get('s2s_text_to_share', 0);
    if ($showShareText) :
        $shareTextPosition = $params->get('s2s_text_to_share_position', 0); // 0 = top, 1 = left
        $shareTextContent = Text::_($params->get('s2s_text_to_share_text', 'SOCIAL2S_SHARE_TEXT'));
        $shareTextClass = 's2s_share_text ' . ($shareTextPosition == 0 ? 's2s_share_text_top' : 's2s_share_text_left');

        // Output share text if position is top
        if ($shareTextPosition == 0) : ?>
            <span class="<?php echo $shareTextClass; ?>"><?php echo htmlspecialchars($shareTextContent); ?></span>
            <div class="clearfix"></div>
        <?php endif; ?>
    <?php endif; ?>


    <?php // --- Main Button Container ---
      // Note: $supraClasses already includes fill, text visibility, and button group classes based on $styles
    ?>
    <div class="s2s_contenedor">

        <?php // Output share text if position is left
        if ($showShareText && $shareTextPosition == 1) : ?>
            <span class="<?php echo $shareTextClass; ?>"><?php echo htmlspecialchars($shareTextContent); ?></span>
        <?php endif; ?>

        <?php
        // --- Social Buttons ---
        // The HTML is pre-generated by S2sTmpl::generateButtonsHtml() and passed in $buttonHtml
        echo $buttonHtml;
        ?>

    </div> <?php // End s2s_contenedor ?>


    <?php
    // --- Credits ---
    if ($params->get('s2s_credits', 1)) : ?>
        <div class="s2s_credits_wrapper">
            <small class="social2s_credits clearfix small">
                powered by <a rel="nofollow noopener noreferrer" target="_blank" href="https://jtotal.org/joomla/plugins/social2s">social2s</a>
            </small>
        </div>
    <?php endif; ?>

</div> <?php // End s2s_supra_contenedor
// --- End Output ---
?>